import type { Body, Meta, UppyFile } from '@uppy/utils/lib/UppyFile';
export type ServiceWorkerStoredFile<M extends Meta, B extends Body> = {
    type: string;
    store: string;
    file: UppyFile<M, B>;
};
type ServiceWorkerStoreOptions = {
    storeName: string;
};
declare class ServiceWorkerStore<M extends Meta, B extends Body> {
    #private;
    name: string;
    static isSupported: boolean;
    constructor(opts: ServiceWorkerStoreOptions);
    get ready(): Promise<void>;
    list(): Promise<ServiceWorkerStoredFile<M, B>[]>;
    put(file: UppyFile<any, any>): Promise<void>;
    delete(fileID: string): Promise<void>;
}
export default ServiceWorkerStore;
//# sourceMappingURL=ServiceWorkerStore.d.ts.map