import type { UppyFile } from '@uppy/utils/lib/UppyFile';
type IndexedDBStoredFile = {
    id: string;
    fileID: string;
    store: string;
    expires: number;
    data: Blob;
};
type IndexedDBStoreOptions = {
    dbName?: string;
    storeName?: string;
    expires?: number;
    maxFileSize?: number;
    maxTotalSize?: number;
};
declare class IndexedDBStore {
    #private;
    opts: Required<IndexedDBStoreOptions>;
    name: string;
    static isSupported: boolean;
    constructor(opts?: IndexedDBStoreOptions);
    get ready(): Promise<IDBDatabase>;
    key(fileID: string): string;
    /**
     * List all file blobs currently in the store.
     */
    list(): Promise<Record<string, IndexedDBStoredFile['data']>>;
    /**
     * Get one file blob from the store.
     */
    get(fileID: string): Promise<{
        id: string;
        data: Blob;
    }>;
    /**
     * Get the total size of all stored files.
     */
    getSize(): Promise<number>;
    /**
     * Save a file in the store.
     */
    put<T>(file: UppyFile<any, any>): Promise<T>;
    /**
     * Delete a file blob from the store.
     */
    delete(fileID: string): Promise<unknown>;
    /**
     * Delete all stored blobs that have an expiry date that is before Date.now().
     * This is a static method because it deletes expired blobs from _all_ Uppy instances.
     */
    static cleanup(): Promise<void>;
}
export default IndexedDBStore;
//# sourceMappingURL=IndexedDBStore.d.ts.map