import type { State as UppyState, Meta, Body } from '@uppy/core';
export type StoredState<M extends Meta, B extends Body> = {
    expires: number;
    metadata: {
        currentUploads: UppyState<M, B>['currentUploads'];
        files: UppyState<M, B>['files'];
        pluginData: Record<string, unknown>;
    };
};
type MetaDataStoreOptions = {
    storeName: string;
    expires?: number;
};
export default class MetaDataStore<M extends Meta, B extends Body> {
    opts: Required<MetaDataStoreOptions>;
    name: string;
    constructor(opts: MetaDataStoreOptions);
    /**
     *
     */
    load(): StoredState<M, B>['metadata'] | null;
    save(metadata: Record<string, unknown>): void;
    /**
     * Remove all expired state.
     */
    static cleanup(instanceID?: string): void;
}
export {};
//# sourceMappingURL=MetaDataStore.d.ts.map