import { BasePlugin } from '@uppy/core';
import type { Body, Meta, UppyFile, Uppy, UploadResult, PluginOpts, DefinePluginOpts } from '@uppy/core';
import ServiceWorkerStore, { type ServiceWorkerStoredFile } from './ServiceWorkerStore.js';
import IndexedDBStore from './IndexedDBStore.js';
import MetaDataStore from './MetaDataStore.js';
declare module '@uppy/core' {
    interface UppyEventMap<M extends Meta, B extends Body> {
        'restore:get-data': (fn: (data: Record<string, unknown>) => void) => void;
    }
}
export interface GoldenRetrieverOptions extends PluginOpts {
    expires?: number;
    serviceWorker?: boolean;
    indexedDB?: {
        name?: string;
        version?: number;
    };
}
declare const defaultOptions: {
    expires: number;
    serviceWorker: boolean;
};
type Opts = DefinePluginOpts<GoldenRetrieverOptions, keyof typeof defaultOptions>;
/**
 * The GoldenRetriever plugin — restores selected files and resumes uploads
 * after a closed tab or a browser crash!
 *
 * Uses localStorage, IndexedDB and ServiceWorker to do its magic, read more:
 * https://uppy.io/blog/2017/07/golden-retriever/
 */
export default class GoldenRetriever<M extends Meta, B extends Body> extends BasePlugin<Opts, M, B> {
    static VERSION: any;
    MetaDataStore: MetaDataStore<M, B>;
    ServiceWorkerStore: ServiceWorkerStore<M, B> | null;
    IndexedDBStore: IndexedDBStore;
    savedPluginData?: Record<string, unknown>;
    constructor(uppy: Uppy<M, B>, opts?: GoldenRetrieverOptions);
    restoreState(): void;
    /**
     * Get file objects that are currently waiting: they've been selected,
     * but aren't yet being uploaded.
     */
    getWaitingFiles(): Record<string, UppyFile<M, B>>;
    /**
     * Get file objects that are currently being uploaded. If a file has finished
     * uploading, but the other files in the same batch have not, the finished
     * file is also returned.
     */
    getUploadingFiles(): Record<string, UppyFile<M, B>>;
    saveFilesStateToLocalStorage(): void;
    loadFileBlobsFromServiceWorker(): Promise<ServiceWorkerStoredFile<M, B> | Record<string, unknown>>;
    loadFileBlobsFromIndexedDB(): ReturnType<IndexedDBStore['list']>;
    onBlobsLoaded(blobs: Record<string, Blob>): void;
    deleteBlobs(fileIDs: string[]): Promise<void>;
    addBlobToStores: (file: UppyFile<M, B>) => void;
    removeBlobFromStores: (file: UppyFile<M, B>) => void;
    replaceBlobInStores: (file: UppyFile<M, B>) => void;
    handleRestoreConfirmed: () => void;
    abortRestore: () => void;
    handleComplete: ({ successful }: UploadResult<M, B>) => void;
    restoreBlobs: () => void;
    install(): void;
    uninstall(): void;
}
export {};
//# sourceMappingURL=index.d.ts.map