import { h } from 'preact';
import { UIPlugin, Uppy } from '@uppy/core';
import { type CompanionPluginOptions } from '@uppy/companion-client';
import type { Body, Meta, AsyncStore, BaseProviderPlugin } from '@uppy/core';
import type { LocaleStrings } from '@uppy/utils/lib/Translator';
import locale from './locale.js';
export type GoogleDrivePickerOptions = CompanionPluginOptions & {
    clientId: string;
    apiKey: string;
    appId: string;
    locale?: LocaleStrings<typeof locale>;
};
export default class GoogleDrivePicker<M extends Meta, B extends Body> extends UIPlugin<GoogleDrivePickerOptions, M, B> implements BaseProviderPlugin {
    static VERSION: any;
    static requestClientId: string;
    type: string;
    icon: () => h.JSX.Element;
    storage: AsyncStore;
    defaultLocale: {
        strings: {
            pluginNameGoogleDrivePicker: string;
        };
    };
    constructor(uppy: Uppy<M, B>, opts: GoogleDrivePickerOptions);
    install(): void;
    uninstall(): void;
    private handleFilesPicked;
    render: () => h.JSX.Element;
}
//# sourceMappingURL=GoogleDrivePicker.d.ts.map