import { type CompanionPluginOptions } from '@uppy/companion-client';
import type { AsyncStore, BaseProviderPlugin, Body, Meta } from '@uppy/core';
import { UIPlugin, type Uppy } from '@uppy/core';
import type { LocaleStrings } from '@uppy/utils';
import locale from './locale.js';
export type GoogleDrivePickerOptions = CompanionPluginOptions & {
    clientId: string;
    apiKey: string;
    appId: string;
    locale?: LocaleStrings<typeof locale>;
};
export default class GoogleDrivePicker<M extends Meta, B extends Body> extends UIPlugin<GoogleDrivePickerOptions, M, B> implements BaseProviderPlugin {
    static VERSION: string;
    static requestClientId: string;
    type: string;
    icon: () => import("preact").JSX.Element;
    storage: AsyncStore;
    defaultLocale: {
        strings: {
            pluginNameGoogleDrivePicker: string;
        };
    };
    constructor(uppy: Uppy<M, B>, opts: GoogleDrivePickerOptions);
    install(): void;
    uninstall(): void;
    private handleFilesPicked;
    render: () => import("preact").JSX.Element;
}
//# sourceMappingURL=GoogleDrivePicker.d.ts.map