import { jsx as _jsx } from "preact/jsx-runtime";
import { RequestClient, tokenStorage, } from '@uppy/companion-client';
import { UIPlugin } from '@uppy/core';
import { GoogleDriveIcon, GooglePickerView, } from '@uppy/provider-views';
import packageJson from '../package.json' with { type: 'json' };
import locale from './locale.js';
export default class GoogleDrivePicker extends UIPlugin {
    static VERSION = packageJson.version;
    static requestClientId = GoogleDrivePicker.name;
    type = 'acquirer';
    icon = GoogleDriveIcon;
    storage;
    defaultLocale = locale;
    constructor(uppy, opts) {
        super(uppy, opts);
        this.id = this.opts.id || 'GoogleDrivePicker';
        this.storage = this.opts.storage || tokenStorage;
        this.defaultLocale = locale;
        this.i18nInit();
        this.title = this.i18n('pluginNameGoogleDrivePicker');
        const client = new RequestClient(uppy, {
            pluginId: this.id,
            provider: 'url',
            companionUrl: this.opts.companionUrl,
            companionHeaders: this.opts.companionHeaders,
            companionCookiesRule: this.opts.companionCookiesRule,
        });
        this.uppy.registerRequestClient(GoogleDrivePicker.requestClientId, client);
    }
    install() {
        const { target } = this.opts;
        if (target) {
            this.mount(target, this);
        }
    }
    uninstall() {
        this.unmount();
    }
    handleFilesPicked = async (files, accessToken) => {
        this.uppy.addFiles(files.map(({ id, mimeType, name, platform, ...rest }) => {
            return {
                source: this.id,
                name,
                type: mimeType,
                data: {
                    size: null, // defer to companion to determine size
                },
                isRemote: true,
                remote: {
                    companionUrl: this.opts.companionUrl,
                    url: `${this.opts.companionUrl}/google-picker/get`,
                    body: {
                        fileId: id,
                        accessToken,
                        platform,
                        ...('url' in rest && { url: rest.url }),
                    },
                    requestClientId: GoogleDrivePicker.requestClientId,
                },
                ...('metadata' in rest && {
                    meta: rest.metadata,
                }), // dunno how to type this
            };
        }));
    };
    render = () => (_jsx(GooglePickerView, { storage: this.storage, pickerType: "drive", uppy: this.uppy, i18n: this.i18n, clientId: this.opts.clientId, apiKey: this.opts.apiKey, appId: this.opts.appId, onFilesPicked: this.handleFilesPicked }));
}
