import { h } from 'preact';
import { UIPlugin, Uppy } from '@uppy/core';
import { type CompanionPluginOptions } from '@uppy/companion-client';
import type { Body, Meta, AsyncStore, BaseProviderPlugin } from '@uppy/core';
import type { LocaleStrings } from '@uppy/utils/lib/Translator';
import locale from './locale.js';
export type GooglePhotosPickerOptions = CompanionPluginOptions & {
    clientId: string;
    locale?: LocaleStrings<typeof locale>;
};
export default class GooglePhotosPicker<M extends Meta, B extends Body> extends UIPlugin<GooglePhotosPickerOptions, M, B> implements BaseProviderPlugin {
    static VERSION: any;
    static requestClientId: string;
    type: string;
    icon: () => h.JSX.Element;
    storage: AsyncStore;
    defaultLocale: {
        strings: {
            pluginNameGooglePhotosPicker: string;
        };
    };
    constructor(uppy: Uppy<M, B>, opts: GooglePhotosPickerOptions);
    install(): void;
    uninstall(): void;
    private handleFilesPicked;
    render: () => h.JSX.Element;
}
//# sourceMappingURL=GooglePhotosPicker.d.ts.map