import { type CompanionPluginOptions } from '@uppy/companion-client';
import type { AsyncStore, BaseProviderPlugin, Body, Meta } from '@uppy/core';
import { UIPlugin, type Uppy } from '@uppy/core';
import type { LocaleStrings } from '@uppy/utils';
import locale from './locale.js';
export type GooglePhotosPickerOptions = CompanionPluginOptions & {
    clientId: string;
    locale?: LocaleStrings<typeof locale>;
};
export default class GooglePhotosPicker<M extends Meta, B extends Body> extends UIPlugin<GooglePhotosPickerOptions, M, B> implements BaseProviderPlugin {
    static VERSION: string;
    static requestClientId: string;
    type: string;
    icon: () => import("preact").JSX.Element;
    storage: AsyncStore;
    defaultLocale: {
        strings: {
            pluginNameGooglePhotosPicker: string;
        };
    };
    constructor(uppy: Uppy<M, B>, opts: GooglePhotosPickerOptions);
    install(): void;
    uninstall(): void;
    private handleFilesPicked;
    render: () => import("preact").JSX.Element;
}
//# sourceMappingURL=GooglePhotosPicker.d.ts.map