import { jsx as _jsx } from "preact/jsx-runtime";
import { RequestClient, tokenStorage, } from '@uppy/companion-client';
import { UIPlugin } from '@uppy/core';
import { GooglePhotosIcon, GooglePickerView, } from '@uppy/provider-views';
import packageJson from '../package.json' with { type: 'json' };
import locale from './locale.js';
export default class GooglePhotosPicker extends UIPlugin {
    static VERSION = packageJson.version;
    static requestClientId = GooglePhotosPicker.name;
    type = 'acquirer';
    icon = GooglePhotosIcon;
    storage;
    defaultLocale = locale;
    constructor(uppy, opts) {
        super(uppy, opts);
        this.id = this.opts.id || 'GooglePhotosPicker';
        this.storage = this.opts.storage || tokenStorage;
        this.defaultLocale = locale;
        this.i18nInit();
        this.title = this.i18n('pluginNameGooglePhotosPicker');
        const client = new RequestClient(uppy, {
            pluginId: this.id,
            provider: 'url',
            companionUrl: this.opts.companionUrl,
            companionHeaders: this.opts.companionHeaders,
            companionCookiesRule: this.opts.companionCookiesRule,
        });
        this.uppy.registerRequestClient(GooglePhotosPicker.requestClientId, client);
    }
    install() {
        const { target } = this.opts;
        if (target) {
            this.mount(target, this);
        }
    }
    uninstall() {
        this.unmount();
    }
    handleFilesPicked = async (files, accessToken) => {
        this.uppy.addFiles(files.map(({ id, mimeType, name, platform, ...rest }) => {
            return {
                source: this.id,
                name,
                type: mimeType,
                data: {
                    size: null, // defer to companion to determine size
                },
                isRemote: true,
                remote: {
                    companionUrl: this.opts.companionUrl,
                    url: `${this.opts.companionUrl}/google-picker/get`,
                    body: {
                        fileId: id,
                        accessToken,
                        platform,
                        ...('url' in rest && { url: rest.url }),
                    },
                    requestClientId: GooglePhotosPicker.requestClientId,
                },
                ...('metadata' in rest && {
                    meta: rest.metadata,
                }), // dunno how to type this
            };
        }));
    };
    render = () => (_jsx(GooglePickerView, { storage: this.storage, pickerType: "photos", uppy: this.uppy, i18n: this.i18n, clientId: this.opts.clientId, onFilesPicked: this.handleFilesPicked }));
}
