import { UIPlugin } from '@uppy/core';
import type { UIPluginOptions, Uppy, DefinePluginOpts, Meta, Body, UppyFile } from '@uppy/core';
import type Cropper from 'cropperjs';
import { h } from 'preact';
import type { LocaleStrings } from '@uppy/utils/lib/Translator';
import locale from './locale.js';
declare global {
    namespace preact {
        interface Component {
            refs: Record<string, any>;
        }
    }
}
type ThumbnailGeneratedCallback<M extends Meta, B extends Body> = (file: UppyFile<M, B>, preview: string) => void;
type GenericCallback<M extends Meta, B extends Body> = (file: UppyFile<M, B>) => void;
declare module '@uppy/core' {
    interface UppyEventMap<M extends Meta, B extends Body> {
        'thumbnail:request': GenericCallback<M, B>;
        'thumbnail:generated': ThumbnailGeneratedCallback<M, B>;
        'file-editor:complete': GenericCallback<M, B>;
        'file-editor:start': GenericCallback<M, B>;
        'file-editor:cancel': GenericCallback<M, B>;
    }
}
export interface Opts extends UIPluginOptions {
    quality?: number;
    cropperOptions?: Cropper.Options & {
        croppedCanvasOptions?: Cropper.GetCroppedCanvasOptions;
    };
    actions?: {
        revert?: boolean;
        rotate?: boolean;
        granularRotate?: boolean;
        flip?: boolean;
        zoomIn?: boolean;
        zoomOut?: boolean;
        cropSquare?: boolean;
        cropWidescreen?: boolean;
        cropWidescreenVertical?: boolean;
    };
    locale?: LocaleStrings<typeof locale>;
}
export type { Opts as ImageEditorOptions };
type PluginState<M extends Meta, B extends Body> = {
    currentImage: UppyFile<M, B> | null;
};
declare const defaultCropperOptions: {
    viewMode: 0;
    background: false;
    autoCropArea: number;
    responsive: true;
    minCropBoxWidth: number;
    minCropBoxHeight: number;
    croppedCanvasOptions: {};
    initialAspectRatio: number;
};
declare const defaultActions: {
    revert: true;
    rotate: true;
    granularRotate: true;
    flip: true;
    zoomIn: true;
    zoomOut: true;
    cropSquare: true;
    cropWidescreen: true;
    cropWidescreenVertical: true;
};
declare const defaultOptions: {
    quality: number;
    actions: {
        revert: true;
        rotate: true;
        granularRotate: true;
        flip: true;
        zoomIn: true;
        zoomOut: true;
        cropSquare: true;
        cropWidescreen: true;
        cropWidescreenVertical: true;
    };
    cropperOptions: {
        viewMode: 0;
        background: false;
        autoCropArea: number;
        responsive: true;
        minCropBoxWidth: number;
        minCropBoxHeight: number;
        croppedCanvasOptions: {};
        initialAspectRatio: number;
    };
};
type InternalImageEditorOpts = Omit<DefinePluginOpts<Opts, keyof typeof defaultOptions>, 'actions' | 'cropperOptions'> & {
    actions: DefinePluginOpts<NonNullable<Opts['actions']>, keyof typeof defaultActions>;
    cropperOptions: DefinePluginOpts<NonNullable<Opts['cropperOptions']>, keyof typeof defaultCropperOptions>;
};
export default class ImageEditor<M extends Meta, B extends Body> extends UIPlugin<InternalImageEditorOpts, M, B, PluginState<M, B>> {
    static VERSION: any;
    cropper: Cropper;
    constructor(uppy: Uppy<M, B>, opts?: Opts);
    canEditFile(file: UppyFile<M, B>): boolean;
    save: () => void;
    storeCropperInstance: (cropper: Cropper) => void;
    selectFile: (file: UppyFile<M, B>) => void;
    install(): void;
    uninstall(): void;
    render(): h.JSX.Element | null;
}
//# sourceMappingURL=ImageEditor.d.ts.map