import type { Body, Meta, UppyFile } from '@uppy/core';
import type { I18n } from '@uppy/utils';
import Cropper from 'cropperjs';
import { Component } from 'preact';
import type ImageEditor from './ImageEditor.js';
type Props<M extends Meta, B extends Body> = {
    currentImage: UppyFile<M, B>;
    storeCropperInstance: (cropper: Cropper) => void;
    opts: ImageEditor<M, B>['opts'];
    i18n: I18n;
    save: () => void;
};
type State = {
    angle90Deg: number;
    angleGranular: number;
    prevCropboxData: Cropper.CropBoxData | null;
};
export default class Editor<M extends Meta, B extends Body> extends Component<Props<M, B>, State> {
    imgElement: HTMLImageElement;
    cropper: Cropper;
    constructor(props: Props<M, B>);
    componentDidMount(): void;
    componentWillUnmount(): void;
    storePrevCropboxData(): void;
    limitCropboxMovement(event: {
        detail: {
            action: string;
        };
    }): void;
    onRotate90Deg: () => void;
    onRotateGranular: (ev: Event) => void;
    renderGranularRotate(): import("preact").JSX.Element;
    renderRevert(): import("preact").JSX.Element;
    renderRotate(): import("preact").JSX.Element;
    renderFlip(): import("preact").JSX.Element;
    renderZoomIn(): import("preact").JSX.Element;
    renderZoomOut(): import("preact").JSX.Element;
    renderCropSquare(): import("preact").JSX.Element;
    renderCropWidescreen(): import("preact").JSX.Element;
    renderCropWidescreenVertical(): import("preact").JSX.Element;
    render(): import("preact").JSX.Element;
}
export {};
//# sourceMappingURL=Editor.d.ts.map