import { Provider, type CompanionPluginOptions } from '@uppy/companion-client';
import { UIPlugin, Uppy } from '@uppy/core';
import { ProviderViews } from '@uppy/provider-views';
import { h, type ComponentChild } from 'preact';
import type { LocaleStrings } from '@uppy/utils/lib/Translator';
import type { UppyFile, Body, Meta, AsyncStore, UnknownProviderPlugin, UnknownProviderPluginState } from '@uppy/core';
import locale from './locale.js';
export type OneDriveOptions = CompanionPluginOptions & {
    locale?: LocaleStrings<typeof locale>;
};
export default class OneDrive<M extends Meta, B extends Body> extends UIPlugin<OneDriveOptions, M, B, UnknownProviderPluginState> implements UnknownProviderPlugin<M, B> {
    static VERSION: any;
    icon: () => h.JSX.Element;
    provider: Provider<M, B>;
    view: ProviderViews<M, B>;
    storage: AsyncStore;
    files: UppyFile<M, B>[];
    rootFolderId: string | null;
    constructor(uppy: Uppy<M, B>, opts: OneDriveOptions);
    install(): void;
    uninstall(): void;
    render(state: unknown): ComponentChild;
}
//# sourceMappingURL=OneDrive.d.ts.map