# @uppy/provider-views

<img src="https://uppy.io/images/logos/uppy-dog-head-arrow.svg" width="120" alt="Uppy logo: a superman puppy in a pink suit" align="right">

<a href="https://www.npmjs.com/package/@uppy/provider-views"><img src="https://img.shields.io/npm/v/@uppy/provider-views.svg?style=flat-square"></a>
<img src="https://github.com/transloadit/uppy/workflows/Tests/badge.svg" alt="CI status for Uppy tests"> <img src="https://github.com/transloadit/uppy/workflows/Companion/badge.svg" alt="CI status for Companion tests"> <img src="https://github.com/transloadit/uppy/workflows/End-to-end%20tests/badge.svg" alt="CI status for browser tests">

View library for Uppy remote provider plugins.

Uppy is being developed by the folks at [Transloadit](https://transloadit.com), a versatile file encoding service.

## Example

```js
const Plugin = require('@uppy/core/lib/plugin')
const { ProviderViews } = require('@uppy/provider-views')

class GoogleDrive extends Plugin {
  constructor () { /* snip */ }
  install () {
    this.view = new ProviderViews(this)
    // snip
  }

  onFirstRender () {
    return Promise.all([
      this.provider.fetchPreAuthToken(),
      this.view.getFolder('root', '/')
    ])
  }

  render (state) {
    return this.view.render(state)
  }
}
```

## Installation

> Unless you are creating a custom provider plugin, you do not need to install this.

```bash
$ npm install @uppy/provider-views
```

<!-- Undocumented currently
## Documentation

Documentation for this plugin can be found on the [Uppy website](https://uppy.io/docs/DOC_PAGE_HERE).
-->

## License

[The MIT License](./LICENSE).
