import { h } from 'preact';
import type { I18n } from '@uppy/utils/lib/Translator';
import type { Body, Meta } from '@uppy/utils/lib/UppyFile';
import type { PartialTreeFolder } from '@uppy/core/lib/Uppy.js';
import type ProviderView from './ProviderView.ts';
type HeaderProps<M extends Meta, B extends Body> = {
    showBreadcrumbs: boolean;
    openFolder: ProviderView<M, B>['openFolder'];
    breadcrumbs: PartialTreeFolder[];
    pluginIcon: () => h.JSX.Element;
    title: string;
    logout: () => void;
    username: string | null;
    i18n: I18n;
};
export default function Header<M extends Meta, B extends Body>(props: HeaderProps<M, B>): h.JSX.Element;
export {};
//# sourceMappingURL=Header.d.ts.map