import { h } from 'preact';
import type { Body, Meta } from '@uppy/utils/lib/UppyFile';
import type { PartialTree, PartialTreeFile, PartialTreeFolderNode, UnknownSearchProviderPlugin } from '@uppy/core/lib/Uppy.js';
import type { CompanionFile } from '@uppy/utils/lib/CompanionFile';
type Optional<T, K extends keyof T> = Pick<Partial<T>, K> & Omit<T, K>;
interface Opts<M extends Meta, B extends Body> {
    provider: UnknownSearchProviderPlugin<M, B>['provider'];
    viewType: 'list' | 'grid' | 'unsplash';
    showTitles: boolean;
    showFilter: boolean;
}
type PassedOpts<M extends Meta, B extends Body> = Optional<Opts<M, B>, 'viewType' | 'showTitles' | 'showFilter'>;
type RenderOpts<M extends Meta, B extends Body> = Omit<PassedOpts<M, B>, 'provider'>;
/**
 * SearchProviderView, used for Unsplash and future image search providers.
 * Extends generic View, shared with regular providers like Google Drive and Instagram.
 */
export default class SearchProviderView<M extends Meta, B extends Body> {
    static VERSION: any;
    plugin: UnknownSearchProviderPlugin<M, B>;
    provider: UnknownSearchProviderPlugin<M, B>['provider'];
    opts: Opts<M, B>;
    isHandlingScroll: boolean;
    lastCheckbox: string | null;
    constructor(plugin: UnknownSearchProviderPlugin<M, B>, opts: PassedOpts<M, B>);
    tearDown(): void;
    setLoading(loading: boolean | string): void;
    resetPluginState(): void;
    cancelSelection(): void;
    search(): Promise<void>;
    handleScroll(event: Event): Promise<void>;
    donePicking(): Promise<void>;
    toggleCheckbox(ourItem: PartialTreeFolderNode | PartialTreeFile, isShiftKeyPressed: boolean): void;
    validateSingleFile: (file: CompanionFile) => string | null;
    getDisplayedPartialTree: () => (PartialTreeFile | PartialTreeFolderNode)[];
    setSearchString: (searchString: string) => void;
    validateAggregateRestrictions: (partialTree: PartialTree) => string | null;
    render(state: unknown, viewOptions?: RenderOpts<M, B>): h.JSX.Element;
}
export {};
//# sourceMappingURL=SearchProviderView.d.ts.map