import { type MutableRef } from 'preact/hooks';
export interface MediaItemBase {
    id: string;
    createTime: string;
}
interface MediaFileMetadataBase {
    width: number;
    height: number;
    cameraMake: string;
    cameraModel: string;
}
interface MediaFileBase {
    baseUrl: string;
    mimeType: string;
    filename: string;
}
export interface VideoMediaItem extends MediaItemBase {
    type: 'VIDEO';
    mediaFile: MediaFileBase & {
        mediaFileMetadata: MediaFileMetadataBase & {
            videoMetadata: {
                fps: number;
                processingStatus: 'UNSPECIFIED' | 'PROCESSING' | 'READY' | 'FAILED';
            };
        };
    };
}
export interface PhotoMediaItem extends MediaItemBase {
    type: 'PHOTO';
    mediaFile: MediaFileBase & {
        mediaFileMetadata: MediaFileMetadataBase & {
            photoMetadata: {
                focalLength: number;
                apertureFNumber: number;
                isoEquivalent: number;
                exposureTime: string;
            };
        };
    };
}
export interface UnspecifiedMediaItem extends MediaItemBase {
    type: 'TYPE_UNSPECIFIED';
    mediaFile: MediaFileBase;
}
export type MediaItem = VideoMediaItem | PhotoMediaItem | UnspecifiedMediaItem;
export interface PickingSession {
    id: string;
    pickerUri: string;
    pollingConfig: {
        pollInterval: string;
        timeoutIn: string;
    };
    expireTime: string;
    mediaItemsSet: boolean;
}
export interface PickedItemBase {
    id: string;
    mimeType: string;
    name: string;
}
export interface PickedDriveItem extends PickedItemBase {
    platform: 'drive';
}
export interface PickedPhotosItem extends PickedItemBase {
    platform: 'photos';
    url: string;
}
export type PickedItem = PickedPhotosItem | PickedDriveItem;
type PickerType = 'drive' | 'photos';
export declare function ensureScriptsInjected(pickerType: PickerType): Promise<void>;
export declare function authorize({ pickerType, clientId, accessToken, }: {
    pickerType: PickerType;
    clientId: string;
    accessToken?: string | null | undefined;
}): Promise<string>;
export declare function logout(accessToken: string): Promise<void>;
export declare class InvalidTokenError extends Error {
    constructor();
}
export declare function showDrivePicker({ token, apiKey, appId, onFilesPicked, signal, }: {
    token: string;
    apiKey: string;
    appId: string;
    onFilesPicked: (files: PickedItem[], accessToken: string) => void;
    signal: AbortSignal | undefined;
}): Promise<void>;
export declare function showPhotosPicker({ token, pickingSession, onPickingSessionChange, signal, }: {
    token: string;
    pickingSession: PickingSession | undefined;
    onPickingSessionChange: (ps: PickingSession) => void;
    signal: AbortSignal | undefined;
}): Promise<void>;
export declare function pollPickingSession({ pickingSessionRef, accessTokenRef, signal, onFilesPicked, onError, }: {
    pickingSessionRef: MutableRef<PickingSession | undefined>;
    accessTokenRef: MutableRef<string | null | undefined>;
    signal: AbortSignal;
    onFilesPicked: (files: PickedItem[], accessToken: string) => void;
    onError: (err: unknown) => void;
}): Promise<void>;
export {};
//# sourceMappingURL=googlePicker.d.ts.map