import { jsx as _jsx, jsxs as _jsxs } from "preact/jsx-runtime";
import { useCallback } from 'preact/hooks';
function GoogleIcon() {
    return (_jsx("svg", { width: "26", height: "26", viewBox: "0 0 26 26", xmlns: "http://www.w3.org/2000/svg", children: _jsxs("g", { fill: "none", "fill-rule": "evenodd", children: [_jsx("circle", { fill: "#FFF", cx: "13", cy: "13", r: "13" }), _jsx("path", { d: "M21.64 13.205c0-.639-.057-1.252-.164-1.841H13v3.481h4.844a4.14 4.14 0 01-1.796 2.716v2.259h2.908c1.702-1.567 2.684-3.875 2.684-6.615z", fill: "#4285F4", "fill-rule": "nonzero" }), _jsx("path", { d: "M13 22c2.43 0 4.467-.806 5.956-2.18l-2.908-2.259c-.806.54-1.837.86-3.048.86-2.344 0-4.328-1.584-5.036-3.711H4.957v2.332A8.997 8.997 0 0013 22z", fill: "#34A853", "fill-rule": "nonzero" }), _jsx("path", { d: "M7.964 14.71A5.41 5.41 0 017.682 13c0-.593.102-1.17.282-1.71V8.958H4.957A8.996 8.996 0 004 13c0 1.452.348 2.827.957 4.042l3.007-2.332z", fill: "#FBBC05", "fill-rule": "nonzero" }), _jsx("path", { d: "M13 7.58c1.321 0 2.508.454 3.44 1.345l2.582-2.58C17.463 4.891 15.426 4 13 4a8.997 8.997 0 00-8.043 4.958l3.007 2.332C8.672 9.163 10.656 7.58 13 7.58z", fill: "#EA4335", "fill-rule": "nonzero" }), _jsx("path", { d: "M4 4h18v18H4z" })] }) }));
}
function DefaultForm({ pluginName, i18n, onAuth, }) {
    // In order to comply with Google's brand we need to create a different button
    // for the Google Drive plugin
    const isGoogleDrive = pluginName === 'Google Drive';
    const onSubmit = useCallback((e) => {
        e.preventDefault();
        onAuth();
    }, [onAuth]);
    return (_jsx("form", { onSubmit: onSubmit, children: isGoogleDrive ? (_jsxs("button", { type: "submit", className: "uppy-u-reset uppy-c-btn uppy-c-btn-primary uppy-Provider-authBtn uppy-Provider-btn-google", "data-uppy-super-focusable": true, children: [_jsx(GoogleIcon, {}), i18n('signInWithGoogle')] })) : (_jsx("button", { type: "submit", className: "uppy-u-reset uppy-c-btn uppy-c-btn-primary uppy-Provider-authBtn", "data-uppy-super-focusable": true, children: i18n('authenticateWith', { pluginName }) })) }));
}
const defaultRenderForm = ({ pluginName, i18n, onAuth, }) => _jsx(DefaultForm, { pluginName: pluginName, i18n: i18n, onAuth: onAuth });
export default function AuthView({ loading, pluginName, pluginIcon, i18n, handleAuth, renderForm = defaultRenderForm, }) {
    return (_jsxs("div", { className: "uppy-Provider-auth", children: [_jsx("div", { className: "uppy-Provider-authIcon", children: pluginIcon() }), _jsx("div", { className: "uppy-Provider-authTitle", children: i18n('authenticateWithTitle', {
                    pluginName,
                }) }), renderForm({ pluginName, i18n, loading, onAuth: handleAuth })] }));
}
