import { BasePlugin } from '@uppy/core';
import type { Uppy, DefinePluginOpts, Body, Meta } from '@uppy/core';
import type { CompanionPluginOptions } from '@uppy/companion-client';
type AvailablePluginsKeys = 'Box' | 'Dropbox' | 'Facebook' | 'GoogleDrive' | 'Instagram' | 'OneDrive' | 'Unsplash' | 'Url' | 'Zoom';
type NestedCompanionKeysParams = {
    [key in AvailablePluginsKeys]?: CompanionPluginOptions['companionKeysParams'];
};
export interface RemoteSourcesOptions extends Omit<CompanionPluginOptions, 'companionKeysParams'> {
    sources?: Array<AvailablePluginsKeys>;
    companionKeysParams?: NestedCompanionKeysParams;
}
declare const defaultOptions: {
    sources: AvailablePluginsKeys[];
};
type Opts = DefinePluginOpts<RemoteSourcesOptions, keyof typeof defaultOptions>;
export default class RemoteSources<M extends Meta, B extends Body> extends BasePlugin<Opts, M, B> {
    #private;
    static VERSION: any;
    constructor(uppy: Uppy<M, B>, opts: RemoteSourcesOptions);
    setOptions(newOpts: Partial<Opts>): void;
    install(): void;
    uninstall(): void;
}
export {};
//# sourceMappingURL=index.d.ts.map