function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
/* eslint-disable react/jsx-props-no-spreading */
import { h, Component } from 'preact';
import RecordButton from "./RecordButton.js";
import SubmitButton from "./SubmitButton.js";
import StopWatch from "./StopWatch.js";
import StreamStatus from "./StreamStatus.js";
class RecorderScreen extends Component {
  componentWillUnmount() {
    const {
      onStop
    } = this.props;
    onStop();
  }
  render() {
    const {
      recording,
      stream: videoStream,
      recordedVideo
    } = this.props;
    const videoProps = {
      playsinline: true
    };

    // show stream
    if (recording || !recordedVideo && !recording) {
      videoProps.muted = true;
      videoProps.autoplay = true;
      videoProps.srcObject = videoStream;
    }

    // show preview
    if (recordedVideo && !recording) {
      videoProps.muted = false;
      videoProps.controls = true;
      videoProps.src = recordedVideo;

      // reset srcObject in dom. If not resetted, stream sticks in element
      if (this.videoElement) {
        this.videoElement.srcObject = undefined;
      }
    }
    return h("div", {
      className: "uppy uppy-ScreenCapture-container"
    }, h("div", {
      className: "uppy-ScreenCapture-videoContainer"
    }, h(StreamStatus, this.props), h("video", _extends({
      ref: videoElement => {
        this.videoElement = videoElement;
      },
      className: "uppy-ScreenCapture-video"
    }, videoProps)), h(StopWatch, this.props)), h("div", {
      className: "uppy-ScreenCapture-buttonContainer"
    }, h(RecordButton, this.props), h(SubmitButton, this.props)));
  }
}
export default RecorderScreen;