import { type ComponentChild } from 'preact';
import { UIPlugin } from '@uppy/core';
import type { LocaleStrings } from '@uppy/utils/lib/Translator';
import type { Uppy, UIPluginOptions, DefinePluginOpts, Body, Meta } from '@uppy/core';
import locale from './locale.js';
export interface ScreenCaptureOptions extends UIPluginOptions {
    displayMediaConstraints?: MediaStreamConstraints;
    userMediaConstraints?: MediaStreamConstraints;
    preferredVideoMimeType?: string;
    locale?: LocaleStrings<typeof locale>;
}
declare const defaultOptions: {
    displayMediaConstraints: {
        video: {
            width: number;
            height: number;
            frameRate: {
                ideal: number;
                max: number;
            };
            cursor: string;
            displaySurface: string;
        };
    };
    userMediaConstraints: {
        audio: boolean;
    };
    preferredVideoMimeType: string;
};
type Opts = DefinePluginOpts<ScreenCaptureOptions, keyof typeof defaultOptions>;
export type ScreenCaptureState = {
    streamActive: boolean;
    audioStreamActive: boolean;
    recording: boolean;
    recordedVideo: string | null;
    screenRecError: string | null;
};
export default class ScreenCapture<M extends Meta, B extends Body> extends UIPlugin<Opts, M, B, ScreenCaptureState> {
    static VERSION: any;
    mediaDevices: MediaDevices;
    protocol: string;
    icon: ComponentChild;
    streamInterrupted: () => void;
    captureActive: boolean;
    capturedMediaFile: null | {
        source: string;
        name: string;
        data: Blob;
        type: string;
    };
    videoStream: null | MediaStream;
    audioStream: null | MediaStream;
    userDenied: boolean;
    recorder: null | MediaRecorder;
    outputStream: null | MediaStream;
    recordingChunks: Blob[] | null;
    constructor(uppy: Uppy<M, B>, opts?: ScreenCaptureOptions);
    install(): null | undefined;
    uninstall(): void;
    start(): Promise<void>;
    selectVideoStreamSource(): Promise<MediaStream | false>;
    selectAudioStreamSource(): Promise<MediaStream | false>;
    startRecording(): void;
    streamInactivated(): void;
    stopRecording(): Promise<void>;
    submit(): void;
    stop(): void;
    getVideo(): Promise<{
        source: string;
        name: string;
        data: Blob;
        type: string;
    }>;
    render(): ComponentChild;
}
export {};
//# sourceMappingURL=ScreenCapture.d.ts.map