import { jsx as _jsx, jsxs as _jsxs } from "preact/jsx-runtime";
import { Component, Fragment } from 'preact';
import DiscardButton from './DiscardButton.js';
import RecordButton from './RecordButton.js';
import ScreenshotButton from './ScreenshotButton.js';
import StopWatch from './StopWatch.js';
import StreamStatus from './StreamStatus.js';
import SubmitButton from './SubmitButton.js';
class RecorderScreen extends Component {
    videoElement = null;
    componentWillUnmount() {
        const { onStop } = this.props;
        onStop();
    }
    render() {
        const { recording, stream: videoStream, recordedVideo, enableScreenshots, capturedScreenshotUrl, } = this.props;
        const videoProps = {
            playsinline: true,
        };
        // show stream
        if (recording || (!recordedVideo && !recording)) {
            videoProps.muted = true;
            videoProps.autoplay = true;
            videoProps.srcObject = videoStream;
        }
        // show preview
        if (recordedVideo && !recording) {
            videoProps.muted = false;
            videoProps.controls = true;
            videoProps.src = recordedVideo;
            // reset srcObject in dom. If not resetted, stream sticks in element
            if (this.videoElement) {
                this.videoElement.srcObject = null;
            }
        }
        return (_jsxs("div", { className: "uppy uppy-ScreenCapture-container", children: [_jsxs("div", { className: "uppy-ScreenCapture-mediaContainer", children: [_jsx(StreamStatus, { ...this.props }), capturedScreenshotUrl && !recording && !recordedVideo ? (_jsx("div", { className: "uppy-ScreenCapture-imageContainer", children: _jsx("img", { src: capturedScreenshotUrl, className: "uppy-ScreenCapture-media", alt: "screenshotPreview" }) })) : (_jsx("video", { ref: (videoElement) => {
                                this.videoElement = videoElement;
                            }, className: "uppy-ScreenCapture-media", ...videoProps })), _jsx("div", { children: _jsx(StopWatch, { ...this.props }) })] }), _jsx("div", { className: "uppy-ScreenCapture-buttonContainer", children: recordedVideo || capturedScreenshotUrl ? (_jsxs(Fragment, { children: [_jsx(SubmitButton, { ...this.props }), _jsx(DiscardButton, { ...this.props })] })) : (_jsxs(Fragment, { children: [enableScreenshots && !recording && (_jsx(ScreenshotButton, { ...this.props })), _jsx(RecordButton, { ...this.props })] })) })] }));
    }
}
export default RecorderScreen;
