import type { Body, DefinePluginOpts, Meta, UIPluginOptions, Uppy } from '@uppy/core';
import { UIPlugin } from '@uppy/core';
import type { LocaleStrings } from '@uppy/utils';
import type { ComponentChild } from 'preact';
import locale from './locale.js';
declare const SUPPORTED_IMAGE_TYPES: readonly ["image/png", "image/jpeg", "image/webp"];
type SupportedImageType = (typeof SUPPORTED_IMAGE_TYPES)[number];
export type ScreenCaptureStatus = 'init' | 'ready' | 'recording' | 'captured' | 'error';
export interface ScreenCaptureOptions extends UIPluginOptions {
    displayMediaConstraints?: MediaStreamConstraints;
    userMediaConstraints?: MediaStreamConstraints;
    preferredVideoMimeType?: string;
    preferredImageMimeType?: SupportedImageType;
    locale?: LocaleStrings<typeof locale>;
    enableScreenshots?: boolean;
}
declare const defaultOptions: {
    displayMediaConstraints: {
        video: {
            width: number;
            height: number;
            frameRate: {
                ideal: number;
                max: number;
            };
            cursor: string;
            displaySurface: string;
        };
    };
    userMediaConstraints: {
        audio: boolean;
    };
    preferredVideoMimeType: string;
    preferredImageMimeType: SupportedImageType;
    enableScreenshots: boolean;
};
type Opts = DefinePluginOpts<ScreenCaptureOptions, keyof typeof defaultOptions>;
export type ScreenCaptureState = {
    streamActive: boolean;
    audioStreamActive: boolean;
    recording: boolean;
    recordedVideo: string | null;
    screenRecError: Error | null;
    capturedScreenshotUrl: string | null;
    status: ScreenCaptureStatus;
};
export default class ScreenCapture<M extends Meta, B extends Body> extends UIPlugin<Opts, M, B, ScreenCaptureState> {
    static VERSION: string;
    mediaDevices: MediaDevices;
    protocol: string;
    icon: ComponentChild;
    streamInterrupted: () => void;
    captureActive: boolean;
    capturedMediaFile: null | {
        source: string;
        name: string;
        data: Blob;
        type: string;
    };
    videoStream: null | MediaStream;
    audioStream: null | MediaStream;
    userDenied: boolean;
    recorder: null | MediaRecorder;
    outputStream: null | MediaStream;
    recordingChunks: Blob[] | null;
    constructor(uppy: Uppy<M, B>, opts?: ScreenCaptureOptions);
    install(): null | undefined;
    uninstall(): void;
    start(): Promise<void>;
    selectVideoStreamSource(): Promise<MediaStream | false>;
    selectAudioStreamSource(): Promise<MediaStream | false>;
    startRecording(): void;
    streamInactivated(): void;
    stopRecording(): Promise<void>;
    discardRecordedMedia(): void;
    submit(): void;
    stop(): void;
    getVideo(): Promise<{
        source: string;
        name: string;
        data: Blob;
        type: string;
    }>;
    captureScreenshot(): Promise<void>;
    render(): ComponentChild;
}
export {};
//# sourceMappingURL=ScreenCapture.d.ts.map