import { jsx as _jsx, jsxs as _jsxs } from "preact/jsx-runtime";
import { Component } from 'preact';
function fmtMSS(s) {
    // biome-ignore lint/suspicious/noAssignInExpressions: ...
    return (s - (s %= 60)) / 60 + (s > 9 ? ':' : ':0') + s;
}
class StopWatch extends Component {
    wrapperStyle = {
        width: '100%',
        height: '100%',
        display: 'flex',
    };
    overlayStyle = {
        position: 'absolute',
        width: '100%',
        height: '100%',
        background: 'black',
        opacity: 0.7,
    };
    infoContainerStyle = {
        marginLeft: 'auto',
        marginRight: 'auto',
        marginTop: 'auto',
        marginBottom: 'auto',
        zIndex: 1,
        color: 'white',
    };
    infotextStyle = {
        marginLeft: 'auto',
        marginRight: 'auto',
        marginBottom: '1rem',
        fontSize: '1.5rem',
    };
    timeStyle = {
        display: 'block',
        fontWeight: 'bold',
        marginLeft: 'auto',
        marginRight: 'auto',
        fontSize: '3rem',
        fontFamily: 'Courier New',
    };
    timerRunning = false;
    timer;
    constructor(props) {
        super(props);
        this.state = { elapsedTime: 0 };
    }
    startTimer() {
        this.timerTick();
        this.timerRunning = true;
    }
    resetTimer() {
        clearTimeout(this.timer);
        this.setState({ elapsedTime: 0 });
        this.timerRunning = false;
    }
    timerTick() {
        this.timer = setTimeout(() => {
            this.setState((state) => ({
                elapsedTime: state.elapsedTime + 1,
            }));
            this.timerTick();
        }, 1000);
    }
    render() {
        const { recording, i18n } = { ...this.props };
        const { elapsedTime } = this.state;
        // second to minutes and seconds
        const minAndSec = fmtMSS(elapsedTime);
        if (recording && !this.timerRunning) {
            this.startTimer();
        }
        if (!recording && this.timerRunning) {
            this.resetTimer();
        }
        if (recording) {
            return (_jsxs("div", { style: this.wrapperStyle, children: [_jsx("div", { style: this.overlayStyle }), _jsxs("div", { style: this.infoContainerStyle, children: [_jsx("div", { style: this.infotextStyle, children: i18n('recording') }), _jsx("div", { style: this.timeStyle, children: minAndSec })] })] }));
        }
        return null;
    }
}
export default StopWatch;
