import type { ComponentChild } from 'preact';
import type { Body, Meta } from '@uppy/utils/lib/UppyFile';
import type { Uppy, State } from '@uppy/core/lib/Uppy.js';
import type { DefinePluginOpts } from '@uppy/core/lib/BasePlugin.js';
import { UIPlugin } from '@uppy/core';
import type { StatusBarOptions } from './StatusBarOptions.ts';
declare const defaultOptions: {
    hideUploadButton: false;
    hideRetryButton: false;
    hidePauseResumeButton: false;
    hideCancelButton: false;
    showProgressDetails: false;
    hideAfterFinish: true;
    doneButtonHandler: null;
};
/**
 * StatusBar: renders a status bar with upload/pause/resume/cancel/retry buttons,
 * progress percentage and time remaining.
 */
export default class StatusBar<M extends Meta, B extends Body> extends UIPlugin<DefinePluginOpts<StatusBarOptions, keyof typeof defaultOptions>, M, B> {
    #private;
    static VERSION: any;
    constructor(uppy: Uppy<M, B>, opts?: StatusBarOptions);
    startUpload: () => ReturnType<Uppy<M, B>['upload']>;
    render(state: State<M, B>): ComponentChild;
    onMount(): void;
    install(): void;
    uninstall(): void;
}
export {};
//# sourceMappingURL=StatusBar.d.ts.map