import type { Body, Meta, UppyFile } from '@uppy/utils/lib/UppyFile';
import type { I18n } from '@uppy/utils/lib/Translator';
import type { Uppy, State } from '@uppy/core/lib/Uppy.js';
import { h } from 'preact';
import statusBarStates from './StatusBarStates.ts';
export interface StatusBarUIProps<M extends Meta, B extends Body> {
    newFiles: number;
    allowNewUpload: boolean;
    isUploadInProgress: boolean;
    isAllPaused: boolean;
    resumableUploads: boolean;
    error: any;
    hideUploadButton?: boolean;
    hidePauseResumeButton?: boolean;
    hideCancelButton?: boolean;
    hideRetryButton?: boolean;
    recoveredState: State<M, B>['recoveredState'];
    uploadState: (typeof statusBarStates)[keyof typeof statusBarStates];
    totalProgress: number;
    files: Record<string, UppyFile<M, B>>;
    supportsUploadProgress: boolean;
    hideAfterFinish?: boolean;
    isSomeGhost: boolean;
    doneButtonHandler?: (() => void) | null;
    isUploadStarted: boolean;
    i18n: I18n;
    startUpload: () => void;
    uppy: Uppy<M, B>;
    isAllComplete: boolean;
    showProgressDetails?: boolean;
    numUploads: number;
    complete: number;
    totalSize: number;
    totalETA: number;
    totalUploadedSize: number;
}
export default function StatusBarUI<M extends Meta, B extends Body>({ newFiles, allowNewUpload, isUploadInProgress, isAllPaused, resumableUploads, error, hideUploadButton, hidePauseResumeButton, hideCancelButton, hideRetryButton, recoveredState, uploadState, totalProgress, files, supportsUploadProgress, hideAfterFinish, isSomeGhost, doneButtonHandler, isUploadStarted, i18n, startUpload, uppy, isAllComplete, showProgressDetails, numUploads, complete, totalSize, totalETA, totalUploadedSize, }: StatusBarUIProps<M, B>): h.JSX.Element;
//# sourceMappingURL=StatusBarUI.d.ts.map