# @uppy/thumbnail-generator

<img src="https://uppy.io/img/logo.svg" width="120" alt="Uppy logo: a smiling puppy above a pink upwards arrow" align="right">

[![npm version](https://img.shields.io/npm/v/@uppy/thumbnail-generator.svg?style=flat-square)](https://www.npmjs.com/package/@uppy/thumbnail-generator)
![CI status for Uppy tests](https://github.com/transloadit/uppy/workflows/CI/badge.svg)
![CI status for Companion tests](https://github.com/transloadit/uppy/workflows/Companion/badge.svg)
![CI status for browser tests](https://github.com/transloadit/uppy/workflows/End-to-end%20tests/badge.svg)

Uppy plugin that generates small previews of images to show on your upload UI.

Uppy is being developed by the folks at [Transloadit](https://transloadit.com),
a versatile file encoding service.

## Example

```js
import Uppy from '@uppy/core'
import ThumbnailGenerator from '@uppy/thumbnail-generator'

const uppy = new Uppy()
uppy.use(ThumbnailGenerator, {
  thumbnailWidth: 200,
})
```

## Installation

```bash
$ npm install @uppy/thumbnail-generator
```

Alternatively, you can also use this plugin in a pre-built bundle from
Transloadit’s CDN: Smart CDN. In that case `Uppy` will attach itself to the
global `window.Uppy` object. See the
[main Uppy documentation](https://uppy.io/docs/#Installation) for instructions.

## Documentation

Documentation for this plugin can be found on the
[Uppy website](https://uppy.io/docs/thumbnail-generator).

## License

[The MIT License](./LICENSE).
