import Emitter from 'component-emitter';
import type { RateLimitedQueue } from '@uppy/utils/lib/RateLimitedQueue';
import type { AssemblyResponse } from './index.js';
declare class TransloaditAssembly extends Emitter {
    #private;
    status: AssemblyResponse;
    pollInterval: ReturnType<typeof setInterval> | null;
    closed: boolean;
    constructor(assembly: AssemblyResponse, rateLimitedQueue: RateLimitedQueue);
    connect(): void;
    update(): Promise<void>;
    /**
     * Update this assembly's status with a full new object. Events will be
     * emitted for status changes, new files, and new results.
     */
    updateStatus(next: AssemblyResponse): void;
    /**
     * Stop updating this assembly.
     */
    close(): void;
}
export default TransloaditAssembly;
//# sourceMappingURL=Assembly.d.ts.map