import type { Uppy, Body, Meta } from '@uppy/core';
import Emitter from 'component-emitter';
/**
 * Track completion of multiple assemblies.
 *
 * Emits 'assembly-complete' when an assembly completes.
 * Emits 'assembly-error' when an assembly fails.
 * Exposes a `.promise` property that resolves when all assemblies have
 * completed (or failed).
 */
declare class TransloaditAssemblyWatcher<M extends Meta, B extends Body> extends Emitter {
    #private;
    promise: Promise<void>;
    constructor(uppy: Uppy<M, B>, assemblyIDs: string[]);
}
export default TransloaditAssemblyWatcher;
//# sourceMappingURL=AssemblyWatcher.d.ts.map