function _classPrivateFieldLooseBase(e, t) { if (!{}.hasOwnProperty.call(e, t)) throw new TypeError("attempted to use private field on non-instance"); return e; }
var id = 0;
function _classPrivateFieldLooseKey(e) { return "__private_" + id++ + "_" + e; }
import fetchWithNetworkError from '@uppy/utils/lib/fetchWithNetworkError';
const ASSEMBLIES_ENDPOINT = '/assemblies';
export class AssemblyError extends Error {
  constructor(message, details, assembly) {
    super(message);
    this.details = details;
    this.assembly = assembly;
  }
}

/**
 * A Barebones HTTP API client for Transloadit.
 */
var _headers = /*#__PURE__*/_classPrivateFieldLooseKey("headers");
var _fetchWithNetworkError = /*#__PURE__*/_classPrivateFieldLooseKey("fetchWithNetworkError");
var _fetchJSON = /*#__PURE__*/_classPrivateFieldLooseKey("fetchJSON");
var _reportError = /*#__PURE__*/_classPrivateFieldLooseKey("reportError");
export default class Client {
  constructor(_opts) {
    Object.defineProperty(this, _fetchJSON, {
      value: _fetchJSON2
    });
    Object.defineProperty(this, _headers, {
      writable: true,
      value: {}
    });
    Object.defineProperty(this, _fetchWithNetworkError, {
      writable: true,
      value: void 0
    });
    Object.defineProperty(this, _reportError, {
      writable: true,
      value: (err, params) => {
        if (this.opts.errorReporting === false) {
          throw err;
        }
        const opts = {
          type: params.type
        };
        if (params.assembly) {
          opts.assembly = params.assembly.assembly_id;
          opts.instance = params.assembly.instance;
        }
        if (params.url) {
          opts.endpoint = params.url;
        }
        this.submitError(err, opts).catch(() => {
          // not much we can do then is there
        });
        throw err;
      }
    });
    this.opts = _opts;
    if (this.opts.client != null) {
      _classPrivateFieldLooseBase(this, _headers)[_headers]['Transloadit-Client'] = this.opts.client;
    }
    _classPrivateFieldLooseBase(this, _fetchWithNetworkError)[_fetchWithNetworkError] = this.opts.rateLimitedQueue.wrapPromiseFunction(fetchWithNetworkError);
  }
  async createAssembly(_ref) {
    let {
      params,
      fields,
      signature,
      expectedFiles
    } = _ref;
    const data = new FormData();
    data.append('params', typeof params === 'string' ? params : JSON.stringify(params));
    if (signature) {
      data.append('signature', signature);
    }
    Object.keys(fields).forEach(key => {
      data.append(key, String(fields[key]));
    });
    data.append('num_expected_upload_files', String(expectedFiles));
    const url = new URL(ASSEMBLIES_ENDPOINT, `${this.opts.service}`).href;
    return _classPrivateFieldLooseBase(this, _fetchJSON)[_fetchJSON](url, {
      method: 'POST',
      headers: _classPrivateFieldLooseBase(this, _headers)[_headers],
      body: data
    }).catch(err => _classPrivateFieldLooseBase(this, _reportError)[_reportError](err, {
      url,
      type: 'API_ERROR'
    }));
  }

  /**
   * Reserve resources for a file in an Assembly. Then addFile can be used later.
   */
  async reserveFile(assembly, file) {
    const size = encodeURIComponent(file.size);
    const url = `${assembly.assembly_ssl_url}/reserve_file?size=${size}`;
    return _classPrivateFieldLooseBase(this, _fetchJSON)[_fetchJSON](url, {
      method: 'POST',
      headers: _classPrivateFieldLooseBase(this, _headers)[_headers]
    }).catch(err => _classPrivateFieldLooseBase(this, _reportError)[_reportError](err, {
      assembly,
      file,
      url,
      type: 'API_ERROR'
    }));
  }

  /**
   * Import a remote file to an Assembly.
   */
  async addFile(assembly, file) {
    var _file$name;
    if (!file.uploadURL) {
      return Promise.reject(new Error('File does not have an `uploadURL`.'));
    }
    const size = encodeURIComponent(file.size);
    const uploadUrl = encodeURIComponent(file.uploadURL);
    const filename = encodeURIComponent((_file$name = file.name) != null ? _file$name : 'Unnamed');
    const fieldname = 'file';
    const qs = `size=${size}&filename=${filename}&fieldname=${fieldname}&s3Url=${uploadUrl}`;
    const url = `${assembly.assembly_ssl_url}/add_file?${qs}`;
    return _classPrivateFieldLooseBase(this, _fetchJSON)[_fetchJSON](url, {
      method: 'POST',
      headers: _classPrivateFieldLooseBase(this, _headers)[_headers]
    }).catch(err => _classPrivateFieldLooseBase(this, _reportError)[_reportError](err, {
      assembly,
      file,
      url,
      type: 'API_ERROR'
    }));
  }

  /**
   * Cancel a running Assembly.
   */
  async cancelAssembly(assembly) {
    const url = assembly.assembly_ssl_url;
    await _classPrivateFieldLooseBase(this, _fetchWithNetworkError)[_fetchWithNetworkError](url, {
      method: 'DELETE',
      headers: _classPrivateFieldLooseBase(this, _headers)[_headers]
    }).catch(err => _classPrivateFieldLooseBase(this, _reportError)[_reportError](err, {
      url,
      type: 'API_ERROR'
    }));
  }

  /**
   * Get the current status for an assembly.
   */
  async getAssemblyStatus(url) {
    return _classPrivateFieldLooseBase(this, _fetchJSON)[_fetchJSON](url, {
      headers: _classPrivateFieldLooseBase(this, _headers)[_headers]
    }).catch(err => _classPrivateFieldLooseBase(this, _reportError)[_reportError](err, {
      url,
      type: 'STATUS_ERROR'
    }));
  }
  async submitError(err, _temp) {
    let {
      endpoint,
      instance,
      assembly
    } = _temp === void 0 ? {} : _temp;
    const message = err.details ? `${err.message} (${err.details})` : err.message;
    return _classPrivateFieldLooseBase(this, _fetchJSON)[_fetchJSON]('https://transloaditstatus.com/client_error', {
      method: 'POST',
      body: JSON.stringify({
        endpoint,
        instance,
        assembly_id: assembly,
        agent: typeof navigator !== 'undefined' ? navigator.userAgent : '',
        client: this.opts.client,
        error: message
      })
    });
  }
}
async function _fetchJSON2() {
  const response = await _classPrivateFieldLooseBase(this, _fetchWithNetworkError)[_fetchWithNetworkError](...arguments);
  if (response.status === 429) {
    this.opts.rateLimitedQueue.rateLimit(2000);
    return _classPrivateFieldLooseBase(this, _fetchJSON)[_fetchJSON](...arguments);
  }
  if (!response.ok) {
    const serverError = new Error(response.statusText);
    // @ts-expect-error statusCode is not a standard property
    serverError.statusCode = response.status;
    if (!`${arguments.length <= 0 ? undefined : arguments[0]}`.endsWith(ASSEMBLIES_ENDPOINT)) return Promise.reject(serverError);

    // Failed assembly requests should return a more detailed error in JSON.
    return response.json().then(assembly => {
      if (!assembly.error) throw serverError;
      const error = new AssemblyError(assembly.error, assembly.message, assembly);
      if (assembly.assembly_id) {
        error.details += ` Assembly ID: ${assembly.assembly_id}`;
      }
      throw error;
    }, err => {
      // eslint-disable-next-line no-param-reassign
      err.cause = serverError;
      throw err;
    });
  }
  return response.json();
}