import { type TusOpts } from '@uppy/tus';
import { BasePlugin } from '@uppy/core';
import type { DefinePluginOpts, PluginOpts, Uppy, Body, Meta, UppyFile } from '@uppy/core';
import Assembly from './Assembly.js';
import Client from './Client.js';
export interface AssemblyFile {
    id: string;
    name: string;
    basename: string;
    ext: string;
    size: number;
    mime: string;
    type: string;
    field: string;
    md5hash: string;
    is_tus_file: boolean;
    original_md5hash: string;
    original_id: string;
    original_name: string;
    original_basename: string;
    original_path: string;
    url: string;
    ssl_url: string;
    tus_upload_url: string;
    meta: Record<string, any>;
}
export interface AssemblyResult extends AssemblyFile {
    cost: number;
    execTime: number;
    queue: string;
    queueTime: number;
    localId: string | null;
}
export interface AssemblyResponse {
    ok: string;
    message?: string;
    assembly_id: string;
    parent_id?: string;
    account_id: string;
    template_id?: string;
    instance: string;
    assembly_url: string;
    assembly_ssl_url: string;
    uppyserver_url: string;
    companion_url: string;
    websocket_url: string;
    tus_url: string;
    bytes_received: number;
    bytes_expected: number;
    upload_duration: number;
    client_agent?: string;
    client_ip?: string;
    client_referer?: string;
    transloadit_client: string;
    start_date: string;
    upload_meta_data_extracted: boolean;
    warnings: any[];
    is_infinite: boolean;
    has_dupe_jobs: boolean;
    execution_start: string;
    execution_duration: number;
    execution_progress?: number;
    queue_duration: number;
    jobs_queue_duration: number;
    notify_start?: any;
    notify_url?: string;
    notify_status?: any;
    notify_response_code?: any;
    notify_duration?: any;
    last_job_completed?: string;
    fields: Record<string, any>;
    running_jobs: any[];
    bytes_usage: number;
    executing_jobs: any[];
    started_jobs: string[];
    parent_assembly_status: any;
    params: string;
    template?: any;
    merged_params: string;
    uploads: AssemblyFile[];
    results: Record<string, AssemblyResult[]>;
    build_id: string;
    error?: string;
    stderr?: string;
    stdout?: string;
    reason?: string;
}
export interface AssemblyParameters {
    auth: {
        key: string;
        expires?: string;
    };
    template_id?: string;
    steps?: {
        [step: string]: Record<string, unknown>;
    };
    fields?: {
        [name: string]: number | string;
    };
    notify_url?: string;
}
export interface AssemblyOptions {
    params?: AssemblyParameters | null;
    fields?: Record<string, string | number> | string[] | null;
    signature?: string | null;
}
export type OptionsWithRestructuredFields = Omit<AssemblyOptions, 'fields'> & {
    fields: Record<string, string | number>;
};
export interface TransloaditOptions<M extends Meta, B extends Body> extends PluginOpts {
    service?: string;
    errorReporting?: boolean;
    waitForEncoding?: boolean;
    waitForMetadata?: boolean;
    importFromUploadURLs?: boolean;
    alwaysRunAssembly?: boolean;
    limit?: number;
    clientName?: string | null;
    retryDelays?: number[];
    assemblyOptions?: AssemblyOptions | (() => Promise<AssemblyOptions> | AssemblyOptions);
}
declare const defaultOptions: {
    service: string;
    errorReporting: true;
    waitForEncoding: false;
    waitForMetadata: false;
    alwaysRunAssembly: false;
    importFromUploadURLs: false;
    limit: number;
    retryDelays: number[];
    clientName: null;
};
export type Opts<M extends Meta, B extends Body> = DefinePluginOpts<TransloaditOptions<M, B>, keyof typeof defaultOptions>;
type TransloaditState = {
    files: Record<string, {
        assembly: string;
        id: string;
        uploadedFile: AssemblyFile;
    }>;
    results: Array<{
        result: AssemblyResult;
        stepName: string;
        id: string;
        assembly: string;
    }>;
};
/**
 * State we want to store in Golden Retriever to be able to recover uploads.
 */
type PersistentState = {
    assemblyResponse: AssemblyResponse;
};
declare module '@uppy/core' {
    interface UppyEventMap<M extends Meta, B extends Body> {
        restored: (pluginData: Record<string, TransloaditState>) => void;
        'restore:get-data': (setData: (arg: Record<string, PersistentState>) => void) => void;
        'transloadit:assembly-created': (assembly: AssemblyResponse, fileIDs: string[]) => void;
        'transloadit:assembly-cancel': (assembly: AssemblyResponse) => void;
        'transloadit:import-error': (assembly: AssemblyResponse, fileID: string, error: Error) => void;
        'transloadit:assembly-error': (assembly: AssemblyResponse, error: Error) => void;
        'transloadit:assembly-executing': (assembly: AssemblyResponse) => void;
        'transloadit:assembly-cancelled': (assembly: AssemblyResponse) => void;
        'transloadit:upload': (file: AssemblyFile, assembly: AssemblyResponse) => void;
        'transloadit:result': (stepName: string, result: AssemblyResult, assembly: AssemblyResponse) => void;
        'transloadit:complete': (assembly: AssemblyResponse) => void;
        'transloadit:execution-progress': (details: {
            progress_combined?: number;
        }) => void;
    }
}
declare module '@uppy/utils/lib/UppyFile' {
    interface UppyFile<M extends Meta, B extends Body> {
        transloadit?: {
            assembly: string;
        };
        tus?: TusOpts<M, B>;
    }
}
declare const COMPANION_URL = "https://api2.transloadit.com/companion";
declare const COMPANION_ALLOWED_HOSTS: RegExp;
/**
 * Upload files to Transloadit using Tus.
 */
export default class Transloadit<M extends Meta, B extends Body> extends BasePlugin<Opts<M, B>, M, B, TransloaditState> {
    #private;
    static VERSION: any;
    client: Client<M, B>;
    assembly?: Assembly;
    completedFiles: Record<string, boolean>;
    restored: Promise<void> | null;
    constructor(uppy: Uppy<M, B>, opts?: TransloaditOptions<M, B>);
    install(): void;
    uninstall(): void;
    getAssembly(): AssemblyResponse | undefined;
    getAssemblyFiles(assemblyID: string): UppyFile<M, B>[];
}
export { COMPANION_URL, COMPANION_ALLOWED_HOSTS };
//# sourceMappingURL=index.d.ts.map