import type { Body, Meta, RateLimitedQueue, UppyFile } from '@uppy/utils';
import type { AssemblyResponse, OptionsWithRestructuredFields } from './index.js';
type Opts = {
    client?: string;
    service: string;
    rateLimitedQueue: RateLimitedQueue;
    errorReporting: boolean;
};
export declare class AssemblyError extends Error {
    details: string | undefined;
    assembly: AssemblyResponse;
    constructor(message: string, details: string | undefined, assembly: AssemblyResponse);
}
/**
 * A Barebones HTTP API client for Transloadit.
 */
export default class Client<M extends Meta, B extends Body> {
    #private;
    opts: Opts;
    constructor(opts: Opts);
    createAssembly({ params, fields, signature, expectedFiles, }: OptionsWithRestructuredFields & {
        expectedFiles: number;
    }): Promise<AssemblyResponse>;
    /**
     * Reserve resources for a file in an Assembly. Then addFile can be used later.
     */
    reserveFile(assembly: AssemblyResponse, file: UppyFile<M, B>): Promise<AssemblyResponse>;
    /**
     * Import a remote file to an Assembly.
     */
    addFile(assembly: AssemblyResponse, file: UppyFile<M, B>): Promise<AssemblyResponse>;
    /**
     * Cancel a running Assembly.
     */
    cancelAssembly(assembly: AssemblyResponse): Promise<void>;
    /**
     * Get the current status for an assembly.
     */
    getAssemblyStatus(url: string): Promise<AssemblyResponse>;
    submitError(err: {
        message?: string;
        details?: string;
    }, { endpoint, instance, assembly, }?: {
        endpoint?: string | URL;
        instance?: string;
        assembly?: string;
    }): Promise<AssemblyResponse>;
}
export {};
//# sourceMappingURL=Client.d.ts.map