import { tokenStorage, type CompanionPluginOptions, SearchProvider } from '@uppy/companion-client';
import { UIPlugin, Uppy } from '@uppy/core';
import { SearchProviderViews } from '@uppy/provider-views';
import { h, type ComponentChild } from 'preact';
import type { UppyFile, Body, Meta } from '@uppy/utils/lib/UppyFile';
import type { UnknownSearchProviderPluginState } from '@uppy/core/lib/Uppy.js';
export type UnsplashOptions = CompanionPluginOptions;
export default class Unsplash<M extends Meta, B extends Body> extends UIPlugin<UnsplashOptions, M, B, UnknownSearchProviderPluginState> {
    static VERSION: any;
    icon: () => h.JSX.Element;
    provider: SearchProvider<M, B>;
    view: SearchProviderViews<M, B>;
    storage: typeof tokenStorage;
    files: UppyFile<M, B>[];
    hostname: string;
    constructor(uppy: Uppy<M, B>, opts: UnsplashOptions);
    install(): void;
    render(state: unknown): ComponentChild;
    uninstall(): void;
}
//# sourceMappingURL=Unsplash.d.ts.map