import { type CompanionPluginOptions, SearchProvider } from '@uppy/companion-client';
import type { AsyncStore, Body, Meta, UnknownSearchProviderPlugin, UnknownSearchProviderPluginState, UppyFile } from '@uppy/core';
import { UIPlugin, type Uppy } from '@uppy/core';
import { SearchProviderViews } from '@uppy/provider-views';
import type { LocaleStrings } from '@uppy/utils';
import { type ComponentChild, h } from 'preact';
import locale from './locale.js';
export type UnsplashOptions = {
    utmSource?: string;
    locale?: LocaleStrings<typeof locale>;
} & CompanionPluginOptions;
export default class Unsplash<M extends Meta, B extends Body> extends UIPlugin<UnsplashOptions, M, B, UnknownSearchProviderPluginState> implements UnknownSearchProviderPlugin<M, B> {
    static VERSION: string;
    icon: () => h.JSX.Element;
    provider: SearchProvider<M, B>;
    view: SearchProviderViews<M, B>;
    storage: AsyncStore;
    files: UppyFile<M, B>[];
    hostname: string;
    constructor(uppy: Uppy<M, B>, opts: UnsplashOptions);
    install(): void;
    render(state: unknown): ComponentChild;
    uninstall(): void;
}
//# sourceMappingURL=Unsplash.d.ts.map