var _class, _temp;

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var _require = require('@uppy/core'),
    Plugin = _require.Plugin;

var Translator = require('@uppy/utils/lib/Translator');

var _require2 = require('preact'),
    h = _require2.h;

var _require3 = require('@uppy/companion-client'),
    RequestClient = _require3.RequestClient;

var UrlUI = require('./UrlUI.js');

var forEachDroppedOrPastedUrl = require('./utils/forEachDroppedOrPastedUrl');

function UrlIcon() {
  return h("svg", {
    "aria-hidden": "true",
    focusable: "false",
    width: "23",
    height: "23",
    viewBox: "0 0 23 23"
  }, h("path", {
    d: "M20.485 11.236l-2.748 2.737c-.184.182-.367.365-.642.547-1.007.73-2.107 1.095-3.298 1.095-1.65 0-3.298-.73-4.398-2.19-.275-.365-.183-1.003.183-1.277.367-.273 1.008-.182 1.283.183 1.191 1.642 3.482 1.915 5.13.73a.714.714 0 0 0 .367-.365l2.75-2.737c1.373-1.46 1.373-3.74-.093-5.108a3.72 3.72 0 0 0-5.13 0L12.33 6.4a.888.888 0 0 1-1.283 0 .88.88 0 0 1 0-1.277l1.558-1.55a5.38 5.38 0 0 1 7.605 0c2.29 2.006 2.382 5.564.274 7.662zm-8.979 6.294L9.95 19.081a3.72 3.72 0 0 1-5.13 0c-1.467-1.368-1.467-3.74-.093-5.108l2.75-2.737.366-.365c.824-.547 1.74-.82 2.748-.73 1.008.183 1.833.639 2.382 1.46.275.365.917.456 1.283.182.367-.273.458-.912.183-1.277-.916-1.186-2.199-1.915-3.573-2.098-1.374-.273-2.84.091-4.031 1.004l-.55.547-2.749 2.737c-2.107 2.189-2.015 5.655.092 7.753C4.727 21.453 6.101 22 7.475 22c1.374 0 2.749-.547 3.848-1.55l1.558-1.551a.88.88 0 0 0 0-1.278c-.367-.364-1.008-.456-1.375-.09z",
    fill: "#FF814F",
    "fill-rule": "nonzero"
  }));
}
/**
 * Url
 *
 */


module.exports = (_temp = _class =
/*#__PURE__*/
function (_Plugin) {
  _inheritsLoose(Url, _Plugin);

  function Url(uppy, opts) {
    var _this;

    _this = _Plugin.call(this, uppy, opts) || this;
    _this.id = _this.opts.id || 'Url';
    _this.title = _this.opts.title || 'Link';
    _this.type = 'acquirer';

    _this.icon = function () {
      return h(UrlIcon, null);
    }; // Set default options and locale


    _this.defaultLocale = {
      strings: {
        import: 'Import',
        enterUrlToImport: 'Enter URL to import a file',
        failedToFetch: 'Companion failed to fetch this URL, please make sure it’s correct',
        enterCorrectUrl: 'Incorrect URL: Please make sure you are entering a direct link to a file'
      }
    };
    var defaultOptions = {};
    _this.opts = _extends({}, defaultOptions, {}, opts);

    _this.i18nInit();

    _this.hostname = _this.opts.companionUrl;

    if (!_this.hostname) {
      throw new Error('Companion hostname is required, please consult https://uppy.io/docs/companion');
    } // Bind all event handlers for referencability


    _this.getMeta = _this.getMeta.bind(_assertThisInitialized(_this));
    _this.addFile = _this.addFile.bind(_assertThisInitialized(_this));
    _this.handleRootDrop = _this.handleRootDrop.bind(_assertThisInitialized(_this));
    _this.handleRootPaste = _this.handleRootPaste.bind(_assertThisInitialized(_this));
    _this.client = new RequestClient(uppy, {
      companionUrl: _this.opts.companionUrl,
      companionHeaders: _this.opts.companionHeaders || _this.opts.serverHeaders
    });
    return _this;
  }

  var _proto = Url.prototype;

  _proto.setOptions = function setOptions(newOpts) {
    _Plugin.prototype.setOptions.call(this, newOpts);

    this.i18nInit();
  };

  _proto.i18nInit = function i18nInit() {
    this.translator = new Translator([this.defaultLocale, this.uppy.locale, this.opts.locale]);
    this.i18n = this.translator.translate.bind(this.translator);
    this.i18nArray = this.translator.translateArray.bind(this.translator);
    this.setPluginState(); // so that UI re-renders and we see the updated locale
  };

  _proto.getFileNameFromUrl = function getFileNameFromUrl(url) {
    return url.substring(url.lastIndexOf('/') + 1);
  };

  _proto.checkIfCorrectURL = function checkIfCorrectURL(url) {
    if (!url) return false;
    var protocol = url.match(/^([a-z0-9]+):\/\//)[1];

    if (protocol !== 'http' && protocol !== 'https') {
      return false;
    }

    return true;
  };

  _proto.addProtocolToURL = function addProtocolToURL(url) {
    var protocolRegex = /^[a-z0-9]+:\/\//;
    var defaultProtocol = 'http://';

    if (protocolRegex.test(url)) {
      return url;
    }

    return defaultProtocol + url;
  };

  _proto.getMeta = function getMeta(url) {
    var _this2 = this;

    return this.client.post('url/meta', {
      url: url
    }).then(function (res) {
      if (res.error) {
        _this2.uppy.log('[URL] Error:');

        _this2.uppy.log(res.error);

        throw new Error('Failed to fetch the file');
      }

      return res;
    });
  };

  _proto.addFile = function addFile(url) {
    var _this3 = this;

    url = this.addProtocolToURL(url);

    if (!this.checkIfCorrectURL(url)) {
      this.uppy.log("[URL] Incorrect URL entered: " + url);
      this.uppy.info(this.i18n('enterCorrectUrl'), 'error', 4000);
      return;
    }

    return this.getMeta(url).then(function (meta) {
      var tagFile = {
        source: _this3.id,
        name: _this3.getFileNameFromUrl(url),
        type: meta.type,
        data: {
          size: meta.size
        },
        isRemote: true,
        body: {
          url: url
        },
        remote: {
          companionUrl: _this3.opts.companionUrl,
          url: _this3.hostname + "/url/get",
          body: {
            fileId: url,
            url: url
          },
          providerOptions: _this3.client.opts
        }
      };
      return tagFile;
    }).then(function (tagFile) {
      _this3.uppy.log('[Url] Adding remote file');

      try {
        _this3.uppy.addFile(tagFile);
      } catch (err) {
        if (!err.isRestriction) {
          _this3.uppy.log(err);
        }
      }
    }).catch(function (err) {
      _this3.uppy.log(err);

      _this3.uppy.info({
        message: _this3.i18n('failedToFetch'),
        details: err
      }, 'error', 4000);
    });
  };

  _proto.handleRootDrop = function handleRootDrop(e) {
    var _this4 = this;

    forEachDroppedOrPastedUrl(e.dataTransfer, 'drop', function (url) {
      _this4.uppy.log("[URL] Adding file from dropped url: " + url);

      _this4.addFile(url);
    });
  };

  _proto.handleRootPaste = function handleRootPaste(e) {
    var _this5 = this;

    forEachDroppedOrPastedUrl(e.clipboardData, 'paste', function (url) {
      _this5.uppy.log("[URL] Adding file from pasted url: " + url);

      _this5.addFile(url);
    });
  };

  _proto.render = function render(state) {
    return h(UrlUI, {
      i18n: this.i18n,
      addFile: this.addFile
    });
  };

  _proto.install = function install() {
    var target = this.opts.target;

    if (target) {
      this.mount(target, this);
    }
  };

  _proto.uninstall = function uninstall() {
    this.unmount();
  };

  return Url;
}(Plugin), _class.VERSION = "1.4.0", _temp);