import { h, type ComponentChild } from 'preact';
import { UIPlugin, Uppy } from '@uppy/core';
import { RequestClient, type CompanionPluginOptions } from '@uppy/companion-client';
import type { Meta, Body } from '@uppy/utils/lib/UppyFile';
declare function canHandleRootDrop(e: DragEvent): boolean;
export type UrlOptions = CompanionPluginOptions;
export default class Url<M extends Meta, B extends Body> extends UIPlugin<UrlOptions, M, B> {
    static VERSION: any;
    static requestClientId: string;
    icon: () => h.JSX.Element;
    hostname: string;
    client: RequestClient<M, B>;
    canHandleRootDrop: typeof canHandleRootDrop;
    constructor(uppy: Uppy<M, B>, opts: UrlOptions);
    private getMeta;
    private addFile;
    private handleRootDrop;
    private handleRootPaste;
    render(): ComponentChild;
    install(): void;
    uninstall(): void;
}
export {};
//# sourceMappingURL=Url.d.ts.map