import { type CompanionPluginOptions, RequestClient } from '@uppy/companion-client';
import type { Body, Meta } from '@uppy/core';
import { UIPlugin, type Uppy } from '@uppy/core';
import type { LocaleStrings } from '@uppy/utils';
import { type ComponentChild, h } from 'preact';
import locale from './locale.js';
declare function canHandleRootDrop(e: DragEvent): boolean;
export type UrlOptions = CompanionPluginOptions & {
    locale?: LocaleStrings<typeof locale>;
};
export default class Url<M extends Meta, B extends Body> extends UIPlugin<UrlOptions, M, B> {
    static VERSION: string;
    static requestClientId: string;
    icon: () => h.JSX.Element;
    hostname: string;
    client: RequestClient<M, B>;
    canHandleRootDrop: typeof canHandleRootDrop;
    constructor(uppy: Uppy<M, B>, opts: UrlOptions);
    private getMeta;
    private addFile;
    private handleRootDrop;
    private handleRootPaste;
    render(): ComponentChild;
    install(): void;
    uninstall(): void;
}
export {};
//# sourceMappingURL=Url.d.ts.map