import getFilesAndDirectoriesFromDirectory from './getFilesAndDirectoriesFromDirectory.ts';
interface FileSystemFileHandle extends FileSystemHandle {
    getFile(): Promise<File>;
}
interface FileSystemDirectoryHandle extends FileSystemHandle {
    values(): AsyncGenerator<FileSystemDirectoryHandle | FileSystemFileHandle, void, undefined>;
}
declare function createPromiseToAddFileOrParseDirectory(entry: FileSystemFileHandle | FileSystemDirectoryHandle, relativePath: string, lastResortFile?: File | null | undefined): AsyncGenerator<File>;
/**
 * Load all files from data transfer, and recursively read any directories.
 * Note that IE is not supported for drag-drop, because IE doesn't support Data Transfers
 *
 * @param {DataTransfer} dataTransfer
 * @param {*} logDropError on error
 */
export default function getFilesFromDataTransfer(dataTransfer: DataTransfer, logDropError: Parameters<typeof getFilesAndDirectoriesFromDirectory>[2]): ReturnType<typeof createPromiseToAddFileOrParseDirectory>;
export {};
//# sourceMappingURL=index.d.ts.map