import type { h } from 'preact';
export interface Locale<T extends number = number> {
    strings: Record<string, string | Record<T, string>>;
    pluralize: (n: number) => T;
}
export type OptionalPluralizeLocale<T extends number = number> = (Omit<Locale<T>, 'pluralize'> & Partial<Pick<Locale<T>, 'pluralize'>>) | undefined;
export type LocaleStrings<T extends NonNullable<OptionalPluralizeLocale>> = {
    strings: Partial<T['strings']>;
};
export type I18n = Translator['translate'];
type Options = {
    smart_count?: number;
} & {
    [key: string]: string | number | h.JSX.Element;
};
/**
 * Translates strings with interpolation & pluralization support.
 * Extensible with custom dictionaries and pluralization functions.
 *
 * Borrows heavily from and inspired by Polyglot https://github.com/airbnb/polyglot.js,
 * basically a stripped-down version of it. Differences: pluralization functions are not hardcoded
 * and can be easily added among with dictionaries, nested objects are used for pluralization
 * as opposed to `||||` delimeter
 *
 * Usage example: `translator.translate('files_chosen', {smart_count: 3})`
 */
export default class Translator {
    #private;
    readonly locale: Locale;
    constructor(locales: Locale | Array<OptionalPluralizeLocale | undefined>, { onMissingKey }?: {
        onMissingKey?: ((key: string) => void) | undefined;
    });
    /**
     * Public translate method
     *
     * @param key
     * @param options with values that will be used later to replace placeholders in string
     * @returns string translated (and interpolated)
     */
    translate(key: string, options?: Options): string;
    /**
     * Get a translation and return the translated and interpolated parts as an array.
     *
     * @returns The translated and interpolated parts, in order.
     */
    translateArray(key: string, options?: Options): Array<string | unknown>;
}
export {};
//# sourceMappingURL=Translator.d.ts.map