var _class, _temp;

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var _require = require('preact'),
    h = _require.h;

var _require2 = require('@uppy/core'),
    Plugin = _require2.Plugin;

var Translator = require('@uppy/utils/lib/Translator');

var getFileTypeExtension = require('@uppy/utils/lib/getFileTypeExtension');

var canvasToBlob = require('@uppy/utils/lib/canvasToBlob');

var supportsMediaRecorder = require('./supportsMediaRecorder');

var CameraIcon = require('./CameraIcon');

var CameraScreen = require('./CameraScreen');

var PermissionsScreen = require('./PermissionsScreen'); // Setup getUserMedia, with polyfill for older browsers
// Adapted from: https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getUserMedia


function getMediaDevices() {
  // eslint-disable-next-line compat/compat
  if (navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
    // eslint-disable-next-line compat/compat
    return navigator.mediaDevices;
  }

  var _getUserMedia = navigator.mozGetUserMedia || navigator.webkitGetUserMedia;

  if (!_getUserMedia) {
    return null;
  }

  return {
    getUserMedia: function getUserMedia(opts) {
      return new Promise(function (resolve, reject) {
        _getUserMedia.call(navigator, opts, resolve, reject);
      });
    }
  };
}
/**
 * Webcam
 */


module.exports = (_temp = _class =
/*#__PURE__*/
function (_Plugin) {
  _inheritsLoose(Webcam, _Plugin);

  function Webcam(uppy, opts) {
    var _this;

    _this = _Plugin.call(this, uppy, opts) || this;
    _this.mediaDevices = getMediaDevices();
    _this.supportsUserMedia = !!_this.mediaDevices;
    _this.protocol = location.protocol.match(/https/i) ? 'https' : 'http';
    _this.id = _this.opts.id || 'Webcam';
    _this.title = _this.opts.title || 'Camera';
    _this.type = 'acquirer';
    _this.icon = CameraIcon;
    _this.defaultLocale = {
      strings: {
        smile: 'Smile!',
        takePicture: 'Take a picture',
        startRecording: 'Begin video recording',
        stopRecording: 'Stop video recording',
        allowAccessTitle: 'Please allow access to your camera',
        allowAccessDescription: 'In order to take pictures or record video with your camera, please allow camera access for this site.'
      } // set default options

    };
    var defaultOptions = {
      onBeforeSnapshot: function onBeforeSnapshot() {
        return Promise.resolve();
      },
      countdown: false,
      modes: ['video-audio', 'video-only', 'audio-only', 'picture'],
      mirror: true,
      facingMode: 'user',
      preferredVideoMimeType: null
    };
    _this.opts = _extends({}, defaultOptions, {}, opts);

    _this.i18nInit();

    _this.install = _this.install.bind(_assertThisInitialized(_this));
    _this.setPluginState = _this.setPluginState.bind(_assertThisInitialized(_this));
    _this.render = _this.render.bind(_assertThisInitialized(_this)); // Camera controls

    _this.start = _this.start.bind(_assertThisInitialized(_this));
    _this.stop = _this.stop.bind(_assertThisInitialized(_this));
    _this.takeSnapshot = _this.takeSnapshot.bind(_assertThisInitialized(_this));
    _this.startRecording = _this.startRecording.bind(_assertThisInitialized(_this));
    _this.stopRecording = _this.stopRecording.bind(_assertThisInitialized(_this));
    _this.oneTwoThreeSmile = _this.oneTwoThreeSmile.bind(_assertThisInitialized(_this));
    _this.focus = _this.focus.bind(_assertThisInitialized(_this));
    _this.webcamActive = false;

    if (_this.opts.countdown) {
      _this.opts.onBeforeSnapshot = _this.oneTwoThreeSmile;
    }

    return _this;
  }

  var _proto = Webcam.prototype;

  _proto.setOptions = function setOptions(newOpts) {
    _Plugin.prototype.setOptions.call(this, newOpts);

    this.i18nInit();
  };

  _proto.i18nInit = function i18nInit() {
    this.translator = new Translator([this.defaultLocale, this.uppy.locale, this.opts.locale]);
    this.i18n = this.translator.translate.bind(this.translator);
    this.i18nArray = this.translator.translateArray.bind(this.translator);
    this.setPluginState(); // so that UI re-renders and we see the updated locale
  };

  _proto.isSupported = function isSupported() {
    return !!this.mediaDevices;
  };

  _proto.getConstraints = function getConstraints() {
    var acceptsAudio = this.opts.modes.indexOf('video-audio') !== -1 || this.opts.modes.indexOf('audio-only') !== -1;
    var acceptsVideo = this.opts.modes.indexOf('video-audio') !== -1 || this.opts.modes.indexOf('video-only') !== -1 || this.opts.modes.indexOf('picture') !== -1;
    return {
      audio: acceptsAudio,
      video: acceptsVideo ? {
        facingMode: this.opts.facingMode
      } : false
    };
  };

  _proto.start = function start() {
    var _this2 = this;

    if (!this.isSupported()) {
      return Promise.reject(new Error('Webcam access not supported'));
    }

    this.webcamActive = true;
    var constraints = this.getConstraints(); // ask user for access to their camera

    return this.mediaDevices.getUserMedia(constraints).then(function (stream) {
      _this2.stream = stream; // this.streamSrc = URL.createObjectURL(this.stream)

      _this2.setPluginState({
        cameraReady: true
      });
    }).catch(function (err) {
      _this2.setPluginState({
        cameraError: err
      });
    });
  };

  _proto.startRecording = function startRecording() {
    var _this3 = this;

    var options = {};
    var preferredVideoMimeType = this.opts.preferredVideoMimeType; // Attempt to use the passed preferredVideoMimeType (if any) during recording.
    // If the browser doesn't support it, we'll fall back to the browser default instead

    if (preferredVideoMimeType && MediaRecorder.isTypeSupported(preferredVideoMimeType) && getFileTypeExtension(preferredVideoMimeType)) {
      options.mimeType = preferredVideoMimeType;
    }

    this.recorder = new MediaRecorder(this.stream, options);
    this.recordingChunks = [];
    this.recorder.addEventListener('dataavailable', function (event) {
      _this3.recordingChunks.push(event.data);
    });
    this.recorder.start();
    this.setPluginState({
      isRecording: true
    });
  };

  _proto.stopRecording = function stopRecording() {
    var _this4 = this;

    var stopped = new Promise(function (resolve, reject) {
      _this4.recorder.addEventListener('stop', function () {
        resolve();
      });

      _this4.recorder.stop();
    });
    return stopped.then(function () {
      _this4.setPluginState({
        isRecording: false
      });

      return _this4.getVideo();
    }).then(function (file) {
      try {
        _this4.uppy.addFile(file);
      } catch (err) {
        // Logging the error, exept restrictions, which is handled in Core
        if (!err.isRestriction) {
          _this4.uppy.log(err);
        }
      }
    }).then(function () {
      _this4.recordingChunks = null;
      _this4.recorder = null; // Close the Dashboard panel if plugin is installed
      // into Dashboard (could be other parent UI plugin)
      // if (this.parent && this.parent.hideAllPanels) {
      //   this.parent.hideAllPanels()
      // }
    }, function (error) {
      _this4.recordingChunks = null;
      _this4.recorder = null;
      throw error;
    });
  };

  _proto.stop = function stop() {
    this.stream.getAudioTracks().forEach(function (track) {
      track.stop();
    });
    this.stream.getVideoTracks().forEach(function (track) {
      track.stop();
    });
    this.webcamActive = false;
    this.stream = null;
  };

  _proto.getVideoElement = function getVideoElement() {
    return this.el.querySelector('.uppy-Webcam-video');
  };

  _proto.oneTwoThreeSmile = function oneTwoThreeSmile() {
    var _this5 = this;

    return new Promise(function (resolve, reject) {
      var count = _this5.opts.countdown;
      var countDown = setInterval(function () {
        if (!_this5.webcamActive) {
          clearInterval(countDown);
          _this5.captureInProgress = false;
          return reject(new Error('Webcam is not active'));
        }

        if (count > 0) {
          _this5.uppy.info(count + "...", 'warning', 800);

          count--;
        } else {
          clearInterval(countDown);

          _this5.uppy.info(_this5.i18n('smile'), 'success', 1500);

          setTimeout(function () {
            return resolve();
          }, 1500);
        }
      }, 1000);
    });
  };

  _proto.takeSnapshot = function takeSnapshot() {
    var _this6 = this;

    if (this.captureInProgress) return;
    this.captureInProgress = true;
    this.opts.onBeforeSnapshot().catch(function (err) {
      var message = typeof err === 'object' ? err.message : err;

      _this6.uppy.info(message, 'error', 5000);

      return Promise.reject(new Error("onBeforeSnapshot: " + message));
    }).then(function () {
      return _this6.getImage();
    }).then(function (tagFile) {
      _this6.captureInProgress = false; // Close the Dashboard panel if plugin is installed
      // into Dashboard (could be other parent UI plugin)
      // if (this.parent && this.parent.hideAllPanels) {
      //   this.parent.hideAllPanels()
      // }

      try {
        _this6.uppy.addFile(tagFile);
      } catch (err) {
        // Logging the error, exept restrictions, which is handled in Core
        if (!err.isRestriction) {
          _this6.uppy.log(err);
        }
      }
    }, function (error) {
      _this6.captureInProgress = false;
      throw error;
    });
  };

  _proto.getImage = function getImage() {
    var _this7 = this;

    var video = this.getVideoElement();

    if (!video) {
      return Promise.reject(new Error('No video element found, likely due to the Webcam tab being closed.'));
    }

    var name = "cam-" + Date.now() + ".jpg";
    var mimeType = 'image/jpeg';
    var width = video.videoWidth;
    var height = video.videoHeight; // const scaleH = this.opts.mirror ? -1 : 1 // Set horizontal scale to -1 if flip horizontal
    // const scaleV = 1
    // const posX = this.opts.mirror ? width * -1 : 0 // Set x position to -100% if flip horizontal
    // const posY = 0

    var canvas = document.createElement('canvas');
    canvas.width = width;
    canvas.height = height;
    var ctx = canvas.getContext('2d');
    ctx.drawImage(video, 0, 0); // ctx.save() // Save the current state
    // ctx.scale(scaleH, scaleV) // Set scale to flip the image
    // ctx.drawImage(video, posX, posY, width, height) // draw the image
    // ctx.restore() // Restore the last saved state

    return canvasToBlob(canvas, mimeType).then(function (blob) {
      return {
        source: _this7.id,
        name: name,
        data: new Blob([blob], {
          type: mimeType
        }),
        type: mimeType
      };
    });
  };

  _proto.getVideo = function getVideo() {
    var mimeType = this.recordingChunks[0].type;
    var fileExtension = getFileTypeExtension(mimeType);

    if (!fileExtension) {
      return Promise.reject(new Error("Could not retrieve recording: Unsupported media type \"" + mimeType + "\""));
    }

    var name = "webcam-" + Date.now() + "." + fileExtension;
    var blob = new Blob(this.recordingChunks, {
      type: mimeType
    });
    var file = {
      source: this.id,
      name: name,
      data: new Blob([blob], {
        type: mimeType
      }),
      type: mimeType
    };
    return Promise.resolve(file);
  };

  _proto.focus = function focus() {
    var _this8 = this;

    if (!this.opts.countdown) return;
    setTimeout(function () {
      _this8.uppy.info(_this8.i18n('smile'), 'success', 1500);
    }, 1000);
  };

  _proto.render = function render(state) {
    if (!this.webcamActive) {
      this.start();
    }

    var webcamState = this.getPluginState();

    if (!webcamState.cameraReady) {
      return h(PermissionsScreen, {
        icon: CameraIcon,
        i18n: this.i18n
      });
    }

    return h(CameraScreen, _extends({}, webcamState, {
      onSnapshot: this.takeSnapshot,
      onStartRecording: this.startRecording,
      onStopRecording: this.stopRecording,
      onFocus: this.focus,
      onStop: this.stop,
      i18n: this.i18n,
      modes: this.opts.modes,
      supportsRecording: supportsMediaRecorder(),
      recording: webcamState.isRecording,
      mirror: this.opts.mirror,
      src: this.stream
    }));
  };

  _proto.install = function install() {
    this.setPluginState({
      cameraReady: false
    });
    var target = this.opts.target;

    if (target) {
      this.mount(target, this);
    }
  };

  _proto.uninstall = function uninstall() {
    if (this.stream) {
      this.stop();
    }

    this.unmount();
  };

  return Webcam;
}(Plugin), _class.VERSION = "1.4.0", _temp);