"use strict";

var _preact = require("preact");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const SnapshotButton = require("./SnapshotButton.js");

const RecordButton = require("./RecordButton.js");

const RecordingLength = require("./RecordingLength.js");

const VideoSourceSelect = require("./VideoSourceSelect.js");

const SubmitButton = require("./SubmitButton.js");

const DiscardButton = require("./DiscardButton.js");

function isModeAvailable(modes, mode) {
  return modes.indexOf(mode) !== -1;
}

class CameraScreen extends _preact.Component {
  componentDidMount() {
    const {
      onFocus
    } = this.props;
    onFocus();
  }

  componentWillUnmount() {
    const {
      onStop
    } = this.props;
    onStop();
  }

  render() {
    const {
      src,
      recordedVideo,
      recording,
      modes,
      supportsRecording,
      videoSources,
      showVideoSourceDropdown,
      showRecordingLength,
      onSubmit,
      i18n,
      mirror,
      onSnapshot,
      onStartRecording,
      onStopRecording,
      onDiscardRecordedVideo,
      recordingLengthSeconds
    } = this.props;
    const hasRecordedVideo = !!recordedVideo;
    const shouldShowRecordButton = !hasRecordedVideo && supportsRecording && (isModeAvailable(modes, 'video-only') || isModeAvailable(modes, 'audio-only') || isModeAvailable(modes, 'video-audio'));
    const shouldShowSnapshotButton = !hasRecordedVideo && isModeAvailable(modes, 'picture');
    const shouldShowRecordingLength = supportsRecording && showRecordingLength && !hasRecordedVideo;
    const shouldShowVideoSourceDropdown = showVideoSourceDropdown && videoSources && videoSources.length > 1;
    const videoProps = {
      playsinline: true
    };

    if (recordedVideo) {
      videoProps.muted = false;
      videoProps.controls = true;
      videoProps.src = recordedVideo; // reset srcObject in dom. If not resetted, stream sticks in element

      if (this.videoElement) {
        this.videoElement.srcObject = undefined;
      }
    } else {
      videoProps.muted = true;
      videoProps.autoplay = true;
      videoProps.srcObject = src;
    }

    return (0, _preact.h)("div", {
      className: "uppy uppy-Webcam-container"
    }, (0, _preact.h)("div", {
      className: "uppy-Webcam-videoContainer"
    }, (0, _preact.h)("video", _extends({
      /* eslint-disable-next-line no-return-assign */
      ref: videoElement => this.videoElement = videoElement,
      className: `uppy-Webcam-video  ${mirror ? 'uppy-Webcam-video--mirrored' : ''}`
      /* eslint-disable-next-line react/jsx-props-no-spreading */

    }, videoProps))), (0, _preact.h)("div", {
      className: "uppy-Webcam-footer"
    }, (0, _preact.h)("div", {
      className: "uppy-Webcam-videoSourceContainer"
    }, shouldShowVideoSourceDropdown ? VideoSourceSelect(this.props) : null), (0, _preact.h)("div", {
      className: "uppy-Webcam-buttonContainer"
    }, shouldShowSnapshotButton && (0, _preact.h)(SnapshotButton, {
      onSnapshot: onSnapshot,
      i18n: i18n
    }), shouldShowRecordButton && (0, _preact.h)(RecordButton, {
      recording: recording,
      onStartRecording: onStartRecording,
      onStopRecording: onStopRecording,
      i18n: i18n
    }), hasRecordedVideo && (0, _preact.h)(SubmitButton, {
      onSubmit: onSubmit,
      i18n: i18n
    }), hasRecordedVideo && (0, _preact.h)(DiscardButton, {
      onDiscard: onDiscardRecordedVideo,
      i18n: i18n
    })), (0, _preact.h)("div", {
      className: "uppy-Webcam-recordingLength"
    }, shouldShowRecordingLength && (0, _preact.h)(RecordingLength, {
      recordingLengthSeconds: recordingLengthSeconds,
      i18n: i18n
    }))));
  }

}

module.exports = CameraScreen;