import type { I18n } from '@uppy/utils/lib/Translator';
import { Component, type ComponentChild } from 'preact';
import { type VideoSourceSelectProps } from './VideoSourceSelect.tsx';
interface CameraScreenProps extends VideoSourceSelectProps {
    onFocus: () => void;
    onStop: () => void;
    src: MediaStream | null;
    recording: boolean;
    recordedVideo: string | null;
    modes: string[];
    supportsRecording: boolean;
    showVideoSourceDropdown: boolean;
    showRecordingLength: boolean;
    onSubmit: () => void;
    i18n: I18n;
    mirror: boolean;
    onSnapshot: () => void;
    onStartRecording: () => void;
    onStopRecording: () => void;
    onDiscardRecordedVideo: () => void;
    recordingLengthSeconds: number;
}
declare class CameraScreen extends Component<CameraScreenProps> {
    private videoElement?;
    refs: any;
    componentDidMount(): void;
    componentWillUnmount(): void;
    render(): ComponentChild;
}
export default CameraScreen;
//# sourceMappingURL=CameraScreen.d.ts.map