import { h } from 'preact';
export default function VideoSourceSelect(_ref) {
  let {
    currentDeviceId,
    videoSources,
    onChangeVideoSource
  } = _ref;
  return h("div", {
    className: "uppy-Webcam-videoSource"
  }, h("select", {
    className: "uppy-u-reset uppy-Webcam-videoSource-select",
    onChange: event => {
      onChangeVideoSource(event.target.value);
    }
  }, videoSources.map(videoSource => h("option", {
    key: videoSource.deviceId,
    value: videoSource.deviceId,
    selected: videoSource.deviceId === currentDeviceId
  }, videoSource.label))));
}