import { type ComponentChild } from 'preact';
import { UIPlugin } from '@uppy/core';
import type { LocaleStrings } from '@uppy/utils/lib/Translator';
import type { Uppy, UIPluginOptions, DefinePluginOpts, Body, Meta, MinimalRequiredUppyFile } from '@uppy/core';
import type { PluginTarget } from '@uppy/core/lib/UIPlugin.js';
import locale from './locale.js';
export interface WebcamOptions<M extends Meta, B extends Body> extends UIPluginOptions {
    target?: PluginTarget<M, B>;
    onBeforeSnapshot?: () => Promise<void>;
    countdown?: number | false;
    modes?: Array<'video-audio' | 'video-only' | 'audio-only' | 'picture'>;
    mirror?: boolean;
    showVideoSourceDropdown?: boolean;
    videoConstraints?: MediaTrackConstraints;
    showRecordingLength?: boolean;
    preferredImageMimeType?: string | null;
    preferredVideoMimeType?: string | null;
    mobileNativeCamera?: boolean;
    locale?: LocaleStrings<typeof locale>;
}
interface WebcamState {
    hasCamera: boolean;
    cameraReady: boolean;
    cameraError: null;
    recordingLengthSeconds: number;
    videoSources: MediaDeviceInfo[];
    currentDeviceId: string | MediaStreamTrack | null | undefined;
    recordedVideo: null | string;
    isRecording: boolean;
    [key: string]: unknown;
}
declare const defaultOptions: {
    onBeforeSnapshot: () => Promise<void>;
    countdown: false;
    modes: any;
    mirror: true;
    showVideoSourceDropdown: false;
    preferredImageMimeType: null;
    preferredVideoMimeType: null;
    showRecordingLength: false;
    mobileNativeCamera: boolean;
};
/**
 * Webcam
 */
export default class Webcam<M extends Meta, B extends Body> extends UIPlugin<DefinePluginOpts<WebcamOptions<M, B>, keyof typeof defaultOptions>, M, B, WebcamState> {
    #private;
    static VERSION: any;
    private mediaDevices;
    private supportsUserMedia;
    private protocol;
    private capturedMediaFile;
    private icon;
    private webcamActive;
    private stream;
    private recorder;
    private recordingChunks;
    private recordingLengthTimer?;
    private captureInProgress;
    constructor(uppy: Uppy<M, B>, opts?: WebcamOptions<M, B>);
    setOptions(newOpts: Partial<WebcamOptions<M, B>>): void;
    hasCameraCheck(): Promise<boolean>;
    isAudioOnly(): boolean;
    getConstraints(deviceId?: string | null): {
        video: false | MediaTrackConstraints;
        audio: boolean;
    };
    start(options?: {
        deviceId: string;
    } | null): Promise<never> | void;
    getMediaRecorderOptions(): {
        mimeType?: string;
    };
    startRecording(): void;
    stopRecording(): Promise<void>;
    discardRecordedVideo(): void;
    submit(): void;
    stop(): Promise<void>;
    getVideoElement(): HTMLVideoElement | null;
    oneTwoThreeSmile(): Promise<void>;
    takeSnapshot(): void;
    getImage(): Promise<MinimalRequiredUppyFile<M, B>>;
    getVideo(): Promise<MinimalRequiredUppyFile<M, B>>;
    focus(): void;
    changeVideoSource(deviceId: string): void;
    updateVideoSources(): void;
    render(): ComponentChild;
    install(): void;
    uninstall(): void;
    onUnmount(): void;
}
export {};
//# sourceMappingURL=Webcam.d.ts.map