import type { I18n } from '@uppy/utils';
import { Component, type ComponentChild } from 'preact';
import { type VideoSourceSelectProps } from './VideoSourceSelect.js';
interface CameraScreenProps extends VideoSourceSelectProps {
    onFocus: () => void;
    onStop: () => void;
    src: MediaStream | null;
    recording: boolean;
    recordedVideo: string | null;
    capturedSnapshot: string | null;
    modes: string[];
    supportsRecording: boolean;
    showVideoSourceDropdown: boolean;
    showRecordingLength: boolean;
    onSubmit: () => void;
    i18n: I18n;
    mirror: boolean;
    onSnapshot: () => void;
    onStartRecording: () => void;
    onStopRecording: () => void;
    onDiscardRecordedMedia: () => void;
    recordingLengthSeconds: number;
}
declare class CameraScreen extends Component<CameraScreenProps> {
    private videoElement?;
    refs: any;
    componentDidMount(): void;
    componentWillUnmount(): void;
    render(): ComponentChild;
}
export default CameraScreen;
//# sourceMappingURL=CameraScreen.d.ts.map