import { jsx as _jsx, jsxs as _jsxs } from "preact/jsx-runtime";
import { Component } from 'preact';
import DiscardButton from './DiscardButton.js';
import RecordButton from './RecordButton.js';
import RecordingLength from './RecordingLength.js';
import SnapshotButton from './SnapshotButton.js';
import SubmitButton from './SubmitButton.js';
import VideoSourceSelect, {} from './VideoSourceSelect.js';
function isModeAvailable(modes, mode) {
    return modes.includes(mode);
}
class CameraScreen extends Component {
    videoElement;
    refs;
    componentDidMount() {
        const { onFocus } = this.props;
        onFocus();
    }
    componentWillUnmount() {
        const { onStop } = this.props;
        onStop();
    }
    render() {
        const { src, recordedVideo, capturedSnapshot, recording, modes, supportsRecording, videoSources, showVideoSourceDropdown, showRecordingLength, onSubmit, i18n, mirror, onSnapshot, onStartRecording, onStopRecording, onDiscardRecordedMedia, recordingLengthSeconds, } = this.props;
        const hasRecordedVideo = !!recordedVideo;
        const hasCapturedSnapshot = !!capturedSnapshot;
        const hasRecordedMedia = hasRecordedVideo || hasCapturedSnapshot;
        const shouldShowRecordButton = !hasRecordedMedia &&
            supportsRecording &&
            (isModeAvailable(modes, 'video-only') ||
                isModeAvailable(modes, 'audio-only') ||
                isModeAvailable(modes, 'video-audio'));
        const shouldShowSnapshotButton = !hasRecordedMedia && isModeAvailable(modes, 'picture');
        const shouldShowRecordingLength = supportsRecording && showRecordingLength && !hasRecordedVideo;
        const shouldShowVideoSourceDropdown = showVideoSourceDropdown && videoSources && videoSources.length > 1;
        const videoProps = {
            playsInline: true,
        };
        if (recordedVideo) {
            videoProps.muted = false;
            videoProps.controls = true;
            videoProps.src = recordedVideo;
            // reset srcObject in dom. If not resetted, stream sticks in element
            if (this.videoElement) {
                this.videoElement.srcObject = null;
            }
        }
        else {
            videoProps.muted = true;
            videoProps.autoPlay = true;
            videoProps.srcObject = src;
        }
        return (_jsxs("div", { className: "uppy uppy-Webcam-container", children: [_jsx("div", { className: "uppy-Webcam-videoContainer", children: capturedSnapshot && !recording && !recordedVideo ? (_jsx("div", { className: "uppy-Webcam-imageContainer", children: _jsx("img", { src: capturedSnapshot, className: "uppy-Webcam-video", alt: "capturedSnapshot" }) })) : (_jsx("video", { ref: (videoElement) => {
                            this.videoElement = videoElement;
                        }, className: `uppy-Webcam-video  ${mirror ? 'uppy-Webcam-video--mirrored' : ''}`, ...videoProps })) }), _jsxs("div", { className: "uppy-Webcam-footer", children: [_jsx("div", { className: "uppy-Webcam-videoSourceContainer", children: shouldShowVideoSourceDropdown
                                ? VideoSourceSelect(this.props)
                                : null }), _jsxs("div", { className: "uppy-Webcam-buttonContainer", children: [shouldShowSnapshotButton && (_jsx(SnapshotButton, { onSnapshot: onSnapshot, i18n: i18n })), shouldShowRecordButton && (_jsx(RecordButton, { recording: recording, onStartRecording: onStartRecording, onStopRecording: onStopRecording, i18n: i18n })), (hasRecordedVideo || hasCapturedSnapshot) && (_jsx(SubmitButton, { onSubmit: onSubmit, i18n: i18n })), (hasRecordedVideo || hasCapturedSnapshot) && (_jsx(DiscardButton, { onDiscard: onDiscardRecordedMedia, i18n: i18n }))] }), _jsx("div", { className: "uppy-Webcam-recordingLength", children: shouldShowRecordingLength && (_jsx(RecordingLength, { recordingLengthSeconds: recordingLengthSeconds })) })] })] }));
    }
}
export default CameraScreen;
