import type { Body, DefinePluginOpts, Meta, MinimalRequiredUppyFile, PluginTarget, UIPluginOptions, Uppy } from '@uppy/core';
import { UIPlugin } from '@uppy/core';
import type { LocaleStrings } from '@uppy/utils';
import { type ComponentChild } from 'preact';
import locale from './locale.js';
export type WebcamStatus = 'init' | 'ready' | 'recording' | 'captured' | 'error';
export interface WebcamOptions<M extends Meta, B extends Body> extends UIPluginOptions {
    target?: PluginTarget<M, B>;
    onBeforeSnapshot?: () => Promise<void>;
    countdown?: number | false;
    modes?: Array<'video-audio' | 'video-only' | 'audio-only' | 'picture'>;
    mirror?: boolean;
    showVideoSourceDropdown?: boolean;
    videoConstraints?: MediaTrackConstraints;
    showRecordingLength?: boolean;
    preferredImageMimeType?: string | null;
    preferredVideoMimeType?: string | null;
    mobileNativeCamera?: boolean;
    locale?: LocaleStrings<typeof locale>;
}
export interface WebcamState {
    hasCamera: boolean;
    cameraReady: boolean;
    cameraError: null | Error;
    recordingLengthSeconds: number;
    videoSources: MediaDeviceInfo[];
    currentDeviceId: string | MediaStreamTrack | null | undefined;
    recordedVideo: null | string;
    capturedSnapshot: null | string;
    isRecording: boolean;
    [key: string]: unknown;
}
export declare const defaultOptions: {
    onBeforeSnapshot: () => Promise<void>;
    countdown: false;
    modes: any;
    mirror: true;
    showVideoSourceDropdown: false;
    preferredImageMimeType: null;
    preferredVideoMimeType: null;
    showRecordingLength: false;
    mobileNativeCamera: boolean;
};
/**
 * Webcam
 */
export default class Webcam<M extends Meta, B extends Body> extends UIPlugin<DefinePluginOpts<WebcamOptions<M, B>, keyof typeof defaultOptions>, M, B, WebcamState> {
    #private;
    static VERSION: string;
    private mediaDevices;
    private supportsUserMedia;
    private protocol;
    private capturedMediaFile;
    private icon;
    webcamActive: boolean;
    stream: MediaStream | null;
    private recorder;
    private recordingChunks;
    private recordingLengthTimer?;
    private captureInProgress;
    constructor(uppy: Uppy<M, B>, opts?: WebcamOptions<M, B>);
    getStatus(): WebcamStatus;
    setOptions(newOpts: Partial<WebcamOptions<M, B>>): void;
    hasCameraCheck(): Promise<boolean>;
    isAudioOnly(): boolean;
    getConstraints(deviceId?: string | null): {
        video: false | MediaTrackConstraints;
        audio: boolean;
    };
    start(options?: {
        deviceId: string;
    } | null): Promise<never> | undefined;
    getMediaRecorderOptions(): {
        mimeType?: string;
    };
    startRecording(): void;
    stopRecording(): Promise<void>;
    discardRecordedMedia(): void;
    submit(): void;
    stop(): Promise<void>;
    getVideoElement(): HTMLVideoElement | null;
    oneTwoThreeSmile(): Promise<void>;
    takeSnapshot(): Promise<void>;
    getImage(): Promise<MinimalRequiredUppyFile<M, B>>;
    getVideo(): Promise<MinimalRequiredUppyFile<M, B>>;
    focus(): void;
    changeVideoSource(deviceId: string): void;
    updateVideoSources(): void;
    render(): ComponentChild;
    install(): void;
    uninstall(): void;
    onUnmount(): void;
}
//# sourceMappingURL=Webcam.d.ts.map