import { h, type ComponentChild } from 'preact';
import { UIPlugin } from '@uppy/core';
import type { Body, Meta, UnknownProviderPlugin, UppyFile, AsyncStore, UnknownProviderPluginState, Uppy } from '@uppy/core';
import { Provider, type CompanionPluginOptions } from '@uppy/companion-client';
import { ProviderViews } from '@uppy/provider-views';
import type { LocaleStrings } from '@uppy/utils/lib/Translator';
import locale from './locale.js';
export type WebdavOptions = CompanionPluginOptions & {
    locale?: LocaleStrings<typeof locale>;
};
export default class Webdav<M extends Meta, B extends Body> extends UIPlugin<WebdavOptions, M, B, UnknownProviderPluginState> implements UnknownProviderPlugin<M, B> {
    static VERSION: any;
    icon: () => h.JSX.Element;
    provider: Provider<M, B>;
    view: ProviderViews<M, B>;
    storage: AsyncStore;
    files: UppyFile<M, B>[];
    rootFolderId: string | null;
    constructor(uppy: Uppy<M, B>, opts: WebdavOptions);
    install(): void;
    uninstall(): void;
    render(state: unknown): ComponentChild;
}
//# sourceMappingURL=Webdav.d.ts.map