function _classPrivateFieldLooseBase(receiver, privateKey) { if (!Object.prototype.hasOwnProperty.call(receiver, privateKey)) { throw new TypeError("attempted to use private field on non-instance"); } return receiver; }
var id = 0;
function _classPrivateFieldLooseKey(name) { return "__private_" + id++ + "_" + name; }
import BasePlugin from '@uppy/core/lib/BasePlugin.js';
import { nanoid } from 'nanoid/non-secure';
import { Provider, RequestClient } from '@uppy/companion-client';
import EventManager from '@uppy/utils/lib/EventManager';
import ProgressTimeout from '@uppy/utils/lib/ProgressTimeout';
import { RateLimitedQueue, internalRateLimitedQueue } from '@uppy/utils/lib/RateLimitedQueue';
import NetworkError from '@uppy/utils/lib/NetworkError';
import isNetworkError from '@uppy/utils/lib/isNetworkError';
import { filterNonFailedFiles, filterFilesToEmitUploadStarted } from '@uppy/utils/lib/fileFilters';
const packageJson = {
  "version": "3.4.1"
};
import locale from './locale.js';
function buildResponseError(xhr, err) {
  let error = err;
  // No error message
  if (!error) error = new Error('Upload error');
  // Got an error message string
  if (typeof error === 'string') error = new Error(error);
  // Got something else
  if (!(error instanceof Error)) {
    error = Object.assign(new Error('Upload error'), {
      data: error
    });
  }
  if (isNetworkError(xhr)) {
    error = new NetworkError(error, xhr);
    return error;
  }
  error.request = xhr;
  return error;
}

/**
 * Set `data.type` in the blob to `file.meta.type`,
 * because we might have detected a more accurate file type in Uppy
 * https://stackoverflow.com/a/50875615
 *
 * @param {object} file File object with `data`, `size` and `meta` properties
 * @returns {object} blob updated with the new `type` set from `file.meta.type`
 */
function setTypeInBlob(file) {
  const dataWithUpdatedType = file.data.slice(0, file.data.size, file.meta.type);
  return dataWithUpdatedType;
}
var _uploadLocalFile = /*#__PURE__*/_classPrivateFieldLooseKey("uploadLocalFile");
var _uploadBundle = /*#__PURE__*/_classPrivateFieldLooseKey("uploadBundle");
var _getCompanionClientArgs = /*#__PURE__*/_classPrivateFieldLooseKey("getCompanionClientArgs");
var _uploadFiles = /*#__PURE__*/_classPrivateFieldLooseKey("uploadFiles");
var _handleUpload = /*#__PURE__*/_classPrivateFieldLooseKey("handleUpload");
export default class XHRUpload extends BasePlugin {
  constructor(uppy, _opts) {
    super(uppy, _opts);
    Object.defineProperty(this, _uploadFiles, {
      value: _uploadFiles2
    });
    Object.defineProperty(this, _getCompanionClientArgs, {
      value: _getCompanionClientArgs2
    });
    Object.defineProperty(this, _uploadBundle, {
      value: _uploadBundle2
    });
    Object.defineProperty(this, _uploadLocalFile, {
      value: _uploadLocalFile2
    });
    Object.defineProperty(this, _handleUpload, {
      writable: true,
      value: async fileIDs => {
        if (fileIDs.length === 0) {
          this.uppy.log('[XHRUpload] No files to upload!');
          return;
        }

        // No limit configured by the user, and no RateLimitedQueue passed in by a "parent" plugin
        // (basically just AwsS3) using the internal symbol
        if (this.opts.limit === 0 && !this.opts[internalRateLimitedQueue]) {
          this.uppy.log('[XHRUpload] When uploading multiple files at once, consider setting the `limit` option (to `10` for example), to limit the number of concurrent uploads, which helps prevent memory and network issues: https://uppy.io/docs/xhr-upload/#limit-0', 'warning');
        }
        this.uppy.log('[XHRUpload] Uploading...');
        const files = this.uppy.getFilesByIds(fileIDs);
        const filesFiltered = filterNonFailedFiles(files);
        const filesToEmit = filterFilesToEmitUploadStarted(filesFiltered);
        this.uppy.emit('upload-start', filesToEmit);
        if (this.opts.bundle) {
          // if bundle: true, we don’t support remote uploads
          const isSomeFileRemote = filesFiltered.some(file => file.isRemote);
          if (isSomeFileRemote) {
            throw new Error('Can’t upload remote files when the `bundle: true` option is set');
          }
          if (typeof this.opts.headers === 'function') {
            throw new TypeError('`headers` may not be a function when the `bundle: true` option is set');
          }
          await _classPrivateFieldLooseBase(this, _uploadBundle)[_uploadBundle](filesFiltered);
        } else {
          await _classPrivateFieldLooseBase(this, _uploadFiles)[_uploadFiles](filesFiltered);
        }
      }
    });
    this.type = 'uploader';
    this.id = this.opts.id || 'XHRUpload';
    this.title = 'XHRUpload';
    this.defaultLocale = locale;

    // Default options
    const defaultOptions = {
      formData: true,
      fieldName: _opts.bundle ? 'files[]' : 'file',
      method: 'post',
      allowedMetaFields: null,
      responseUrlFieldName: 'url',
      bundle: false,
      headers: {},
      timeout: 30 * 1000,
      limit: 5,
      withCredentials: false,
      responseType: '',
      /**
       * @param {string} responseText the response body string
       */
      getResponseData(responseText) {
        let parsedResponse = {};
        try {
          parsedResponse = JSON.parse(responseText);
        } catch (err) {
          uppy.log(err);
        }
        return parsedResponse;
      },
      /**
       *
       * @param {string} _ the response body string
       * @param {XMLHttpRequest | respObj} response the response object (XHR or similar)
       */
      getResponseError(_, response) {
        let error = new Error('Upload error');
        if (isNetworkError(response)) {
          error = new NetworkError(error, response);
        }
        return error;
      },
      /**
       * Check if the response from the upload endpoint indicates that the upload was successful.
       *
       * @param {number} status the response status code
       */
      validateStatus(status) {
        return status >= 200 && status < 300;
      }
    };
    this.opts = {
      ...defaultOptions,
      ..._opts
    };
    this.i18nInit();

    // Simultaneous upload limiting is shared across all uploads with this plugin.
    if (internalRateLimitedQueue in this.opts) {
      this.requests = this.opts[internalRateLimitedQueue];
    } else {
      this.requests = new RateLimitedQueue(this.opts.limit);
    }
    if (this.opts.bundle && !this.opts.formData) {
      throw new Error('`opts.formData` must be true when `opts.bundle` is enabled.');
    }
    if ((_opts == null ? void 0 : _opts.allowedMetaFields) === undefined && 'metaFields' in this.opts) {
      throw new Error('The `metaFields` option has been renamed to `allowedMetaFields`.');
    }
    this.uploaderEvents = Object.create(null);
  }
  getOptions(file) {
    const overrides = this.uppy.getState().xhrUpload;
    const {
      headers
    } = this.opts;
    const opts = {
      ...this.opts,
      ...(overrides || {}),
      ...(file.xhrUpload || {}),
      headers: {}
    };
    // Support for `headers` as a function, only in the XHRUpload settings.
    // Options set by other plugins in Uppy state or on the files themselves are still merged in afterward.
    //
    // ```js
    // headers: (file) => ({ expires: file.meta.expires })
    // ```
    if (typeof headers === 'function') {
      opts.headers = headers(file);
    } else {
      Object.assign(opts.headers, this.opts.headers);
    }
    if (overrides) {
      Object.assign(opts.headers, overrides.headers);
    }
    if (file.xhrUpload) {
      Object.assign(opts.headers, file.xhrUpload.headers);
    }
    return opts;
  }

  // eslint-disable-next-line class-methods-use-this
  addMetadata(formData, meta, opts) {
    const allowedMetaFields = Array.isArray(opts.allowedMetaFields) ? opts.allowedMetaFields : Object.keys(meta); // Send along all fields by default.

    allowedMetaFields.forEach(item => {
      if (Array.isArray(meta[item])) {
        // In this case we don't transform `item` to add brackets, it's up to
        // the user to add the brackets so it won't be overridden.
        meta[item].forEach(subItem => formData.append(item, subItem));
      } else {
        formData.append(item, meta[item]);
      }
    });
  }
  createFormDataUpload(file, opts) {
    const formPost = new FormData();
    this.addMetadata(formPost, file.meta, opts);
    const dataWithUpdatedType = setTypeInBlob(file);
    if (file.name) {
      formPost.append(opts.fieldName, dataWithUpdatedType, file.meta.name);
    } else {
      formPost.append(opts.fieldName, dataWithUpdatedType);
    }
    return formPost;
  }
  createBundledUpload(files, opts) {
    const formPost = new FormData();
    const {
      meta
    } = this.uppy.getState();
    this.addMetadata(formPost, meta, opts);
    files.forEach(file => {
      const options = this.getOptions(file);
      const dataWithUpdatedType = setTypeInBlob(file);
      if (file.name) {
        formPost.append(options.fieldName, dataWithUpdatedType, file.name);
      } else {
        formPost.append(options.fieldName, dataWithUpdatedType);
      }
    });
    return formPost;
  }
  install() {
    if (this.opts.bundle) {
      const {
        capabilities
      } = this.uppy.getState();
      this.uppy.setState({
        capabilities: {
          ...capabilities,
          individualCancellation: false
        }
      });
    }
    this.uppy.addUploader(_classPrivateFieldLooseBase(this, _handleUpload)[_handleUpload]);
  }
  uninstall() {
    if (this.opts.bundle) {
      const {
        capabilities
      } = this.uppy.getState();
      this.uppy.setState({
        capabilities: {
          ...capabilities,
          individualCancellation: true
        }
      });
    }
    this.uppy.removeUploader(_classPrivateFieldLooseBase(this, _handleUpload)[_handleUpload]);
  }
}
async function _uploadLocalFile2(file, current, total) {
  const opts = this.getOptions(file);
  this.uppy.log(`uploading ${current} of ${total}`);
  return new Promise((resolve, reject) => {
    const data = opts.formData ? this.createFormDataUpload(file, opts) : file.data;
    const xhr = new XMLHttpRequest();
    const eventManager = new EventManager(this.uppy);
    this.uploaderEvents[file.id] = eventManager;
    let queuedRequest;
    const timer = new ProgressTimeout(opts.timeout, () => {
      const error = new Error(this.i18n('uploadStalled', {
        seconds: Math.ceil(opts.timeout / 1000)
      }));
      this.uppy.emit('upload-stalled', error, [file]);
    });
    const id = nanoid();
    xhr.upload.addEventListener('loadstart', () => {
      this.uppy.log(`[XHRUpload] ${id} started`);
    });
    xhr.upload.addEventListener('progress', ev => {
      this.uppy.log(`[XHRUpload] ${id} progress: ${ev.loaded} / ${ev.total}`);
      // Begin checking for timeouts when progress starts, instead of loading,
      // to avoid timing out requests on browser concurrency queue
      timer.progress();
      if (ev.lengthComputable) {
        this.uppy.emit('upload-progress', file, {
          uploader: this,
          bytesUploaded: ev.loaded,
          bytesTotal: ev.total
        });
      }
    });
    xhr.addEventListener('load', () => {
      this.uppy.log(`[XHRUpload] ${id} finished`);
      timer.done();
      queuedRequest.done();
      if (this.uploaderEvents[file.id]) {
        this.uploaderEvents[file.id].remove();
        this.uploaderEvents[file.id] = null;
      }
      if (opts.validateStatus(xhr.status, xhr.responseText, xhr)) {
        const body = opts.getResponseData(xhr.responseText, xhr);
        const uploadURL = body[opts.responseUrlFieldName];
        const uploadResp = {
          status: xhr.status,
          body,
          uploadURL
        };
        this.uppy.emit('upload-success', file, uploadResp);
        if (uploadURL) {
          this.uppy.log(`Download ${file.name} from ${uploadURL}`);
        }
        return resolve(file);
      }
      const body = opts.getResponseData(xhr.responseText, xhr);
      const error = buildResponseError(xhr, opts.getResponseError(xhr.responseText, xhr));
      const response = {
        status: xhr.status,
        body
      };
      this.uppy.emit('upload-error', file, error, response);
      return reject(error);
    });
    xhr.addEventListener('error', () => {
      this.uppy.log(`[XHRUpload] ${id} errored`);
      timer.done();
      queuedRequest.done();
      if (this.uploaderEvents[file.id]) {
        this.uploaderEvents[file.id].remove();
        this.uploaderEvents[file.id] = null;
      }
      const error = buildResponseError(xhr, opts.getResponseError(xhr.responseText, xhr));
      this.uppy.emit('upload-error', file, error);
      return reject(error);
    });
    xhr.open(opts.method.toUpperCase(), opts.endpoint, true);
    // IE10 does not allow setting `withCredentials` and `responseType`
    // before `open()` is called.
    xhr.withCredentials = opts.withCredentials;
    if (opts.responseType !== '') {
      xhr.responseType = opts.responseType;
    }
    queuedRequest = this.requests.run(() => {
      // When using an authentication system like JWT, the bearer token goes as a header. This
      // header needs to be fresh each time the token is refreshed so computing and setting the
      // headers just before the upload starts enables this kind of authentication to work properly.
      // Otherwise, half-way through the list of uploads the token could be stale and the upload would fail.
      const currentOpts = this.getOptions(file);
      Object.keys(currentOpts.headers).forEach(header => {
        xhr.setRequestHeader(header, currentOpts.headers[header]);
      });
      xhr.send(data);
      return () => {
        timer.done();
        xhr.abort();
      };
    });
    eventManager.onFileRemove(file.id, () => {
      queuedRequest.abort();
      reject(new Error('File removed'));
    });
    eventManager.onCancelAll(file.id, _ref => {
      let {
        reason
      } = _ref;
      if (reason === 'user') {
        queuedRequest.abort();
      }
      reject(new Error('Upload cancelled'));
    });
  });
}
function _uploadBundle2(files) {
  return new Promise((resolve, reject) => {
    const {
      endpoint
    } = this.opts;
    const {
      method
    } = this.opts;
    const optsFromState = this.uppy.getState().xhrUpload;
    const formData = this.createBundledUpload(files, {
      ...this.opts,
      ...(optsFromState || {})
    });
    const xhr = new XMLHttpRequest();
    const emitError = error => {
      files.forEach(file => {
        this.uppy.emit('upload-error', file, error);
      });
    };
    const timer = new ProgressTimeout(this.opts.timeout, () => {
      const error = new Error(this.i18n('uploadStalled', {
        seconds: Math.ceil(this.opts.timeout / 1000)
      }));
      this.uppy.emit('upload-stalled', error, files);
    });
    xhr.upload.addEventListener('loadstart', () => {
      this.uppy.log('[XHRUpload] started uploading bundle');
      timer.progress();
    });
    xhr.upload.addEventListener('progress', ev => {
      timer.progress();
      if (!ev.lengthComputable) return;
      files.forEach(file => {
        this.uppy.emit('upload-progress', file, {
          uploader: this,
          bytesUploaded: ev.loaded / ev.total * file.size,
          bytesTotal: file.size
        });
      });
    });
    xhr.addEventListener('load', ev => {
      timer.done();
      if (this.opts.validateStatus(ev.target.status, xhr.responseText, xhr)) {
        const body = this.opts.getResponseData(xhr.responseText, xhr);
        const uploadResp = {
          status: ev.target.status,
          body
        };
        files.forEach(file => {
          this.uppy.emit('upload-success', file, uploadResp);
        });
        return resolve();
      }
      const error = this.opts.getResponseError(xhr.responseText, xhr) || new Error('Upload error');
      error.request = xhr;
      emitError(error);
      return reject(error);
    });
    xhr.addEventListener('error', () => {
      timer.done();
      const error = this.opts.getResponseError(xhr.responseText, xhr) || new Error('Upload error');
      emitError(error);
      return reject(error);
    });
    this.uppy.on('cancel-all', function (_temp) {
      let {
        reason
      } = _temp === void 0 ? {} : _temp;
      if (reason !== 'user') return;
      timer.done();
      xhr.abort();
    });
    xhr.open(method.toUpperCase(), endpoint, true);
    // IE10 does not allow setting `withCredentials` and `responseType`
    // before `open()` is called.
    xhr.withCredentials = this.opts.withCredentials;
    if (this.opts.responseType !== '') {
      xhr.responseType = this.opts.responseType;
    }
    Object.keys(this.opts.headers).forEach(header => {
      xhr.setRequestHeader(header, this.opts.headers[header]);
    });
    xhr.send(formData);
  });
}
function _getCompanionClientArgs2(file) {
  const opts = this.getOptions(file);
  const allowedMetaFields = Array.isArray(opts.allowedMetaFields) ? opts.allowedMetaFields
  // Send along all fields by default.
  : Object.keys(file.meta);
  return {
    ...file.remote.body,
    protocol: 'multipart',
    endpoint: opts.endpoint,
    size: file.data.size,
    fieldname: opts.fieldName,
    metadata: Object.fromEntries(allowedMetaFields.map(name => [name, file.meta[name]])),
    httpMethod: opts.method,
    useFormData: opts.formData,
    headers: opts.headers
  };
}
async function _uploadFiles2(files) {
  await Promise.allSettled(files.map((file, i) => {
    const current = parseInt(i, 10) + 1;
    const total = files.length;
    if (file.isRemote) {
      // INFO: the url plugin needs to use RequestClient,
      // while others use Provider
      const Client = file.remote.providerOptions.provider ? Provider : RequestClient;
      const getQueue = () => this.requests;
      const client = new Client(this.uppy, file.remote.providerOptions, getQueue);
      const controller = new AbortController();
      const removedHandler = removedFile => {
        if (removedFile.id === file.id) controller.abort();
      };
      this.uppy.on('file-removed', removedHandler);
      const uploadPromise = client.uploadRemoteFile(file, _classPrivateFieldLooseBase(this, _getCompanionClientArgs)[_getCompanionClientArgs](file), {
        signal: controller.signal
      });
      this.requests.wrapSyncFunction(() => {
        this.uppy.off('file-removed', removedHandler);
      }, {
        priority: -1
      })();
      return uploadPromise;
    }
    return _classPrivateFieldLooseBase(this, _uploadLocalFile)[_uploadLocalFile](file, current, total);
  }));
}
// eslint-disable-next-line global-require
XHRUpload.VERSION = packageJson.version;