import BasePlugin from '@uppy/core/lib/BasePlugin.js';
import type { DefinePluginOpts, PluginOpts } from '@uppy/core/lib/BasePlugin.js';
import EventManager from '@uppy/core/lib/EventManager.js';
import { RateLimitedQueue } from '@uppy/utils/lib/RateLimitedQueue';
import { type FetcherOptions } from '@uppy/utils/lib/fetcher';
import type { Meta, Body, UppyFile } from '@uppy/utils/lib/UppyFile';
import type { State, Uppy } from '@uppy/core';
export interface XhrUploadOpts<M extends Meta, B extends Body> extends PluginOpts {
    endpoint: string;
    method?: 'GET' | 'HEAD' | 'POST' | 'PUT' | 'DELETE' | 'OPTIONS' | 'PATCH' | 'delete' | 'get' | 'head' | 'options' | 'post' | 'put' | string;
    formData?: boolean;
    fieldName?: string;
    headers?: Record<string, string> | ((file: UppyFile<M, B>) => Record<string, string>);
    timeout?: number;
    limit?: number;
    responseType?: XMLHttpRequestResponseType;
    withCredentials?: boolean;
    onBeforeRequest?: (xhr: XMLHttpRequest, retryCount: number, 
    /** The files to be uploaded. When `bundle` is `false` only one file is in the array.  */
    files: UppyFile<M, B>[]) => void | Promise<void>;
    shouldRetry?: FetcherOptions['shouldRetry'];
    onAfterResponse?: FetcherOptions['onAfterResponse'];
    getResponseData?: (xhr: XMLHttpRequest) => B | Promise<B>;
    allowedMetaFields?: boolean | string[];
    bundle?: boolean;
}
export type { XhrUploadOpts as XHRUploadOptions };
declare module '@uppy/utils/lib/UppyFile' {
    interface UppyFile<M extends Meta, B extends Body> {
        xhrUpload?: XhrUploadOpts<M, B>;
    }
}
declare module '@uppy/core' {
    interface State<M extends Meta, B extends Body> {
        xhrUpload?: XhrUploadOpts<M, B>;
    }
}
declare const defaultOptions: {
    formData: true;
    fieldName: string;
    method: string;
    allowedMetaFields: true;
    bundle: false;
    headers: {};
    timeout: number;
    limit: number;
    withCredentials: false;
    responseType: "";
};
type Opts<M extends Meta, B extends Body> = DefinePluginOpts<XhrUploadOpts<M, B>, keyof typeof defaultOptions>;
interface OptsWithHeaders<M extends Meta, B extends Body> extends Opts<M, B> {
    headers: Record<string, string>;
}
export default class XHRUpload<M extends Meta, B extends Body> extends BasePlugin<Opts<M, B>, M, B> {
    #private;
    static VERSION: any;
    requests: RateLimitedQueue;
    uploaderEvents: Record<string, EventManager<M, B> | null>;
    constructor(uppy: Uppy<M, B>, opts: XhrUploadOpts<M, B>);
    getOptions(file: UppyFile<M, B>): OptsWithHeaders<M, B>;
    addMetadata(formData: FormData, meta: State<M, B>['meta'], opts: Opts<M, B>): void;
    createFormDataUpload(file: UppyFile<M, B>, opts: Opts<M, B>): FormData;
    createBundledUpload(files: UppyFile<M, B>[], opts: Opts<M, B>): FormData;
    install(): void;
    uninstall(): void;
}
//# sourceMappingURL=index.d.ts.map